/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cmdline;

import com.mchange.v2.cmdline.BadCommandLineException;
import com.mchange.v2.cmdline.MissingSwitchException;
import com.mchange.v2.cmdline.ParsedCommandLine;
import com.mchange.v2.cmdline.UnexpectedSwitchArgumentException;
import com.mchange.v2.cmdline.UnexpectedSwitchException;
import java.util.HashMap;
import java.util.LinkedList;

class ParsedCommandLineImpl
implements ParsedCommandLine {
    String[] argv;
    String switchPrefix;
    String[] unswitchedArgs;
    HashMap foundSwitches = new HashMap();

    ParsedCommandLineImpl(String[] argv, String switchPrefix, String[] validSwitches, String[] requiredSwitches, String[] argSwitches) throws BadCommandLineException {
        this.argv = argv;
        this.switchPrefix = switchPrefix;
        LinkedList<String> unswitchedArgsList = new LinkedList<String>();
        int sp_len = switchPrefix.length();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].startsWith(switchPrefix)) {
                String sw = argv[i].substring(sp_len);
                String arg = null;
                int eq = sw.indexOf(61);
                if (eq >= 0) {
                    arg = sw.substring(eq + 1);
                    sw = sw.substring(0, eq);
                } else if (ParsedCommandLineImpl.contains(sw, argSwitches) && i < argv.length - 1 && !argv[i + 1].startsWith(switchPrefix)) {
                    arg = argv[++i];
                }
                if (validSwitches != null && !ParsedCommandLineImpl.contains(sw, validSwitches)) {
                    throw new UnexpectedSwitchException("Unexpected Switch: " + sw, sw);
                }
                if (argSwitches != null && arg != null && !ParsedCommandLineImpl.contains(sw, argSwitches)) {
                    throw new UnexpectedSwitchArgumentException("Switch \"" + sw + "\" should not have an " + "argument. Argument \"" + arg + "\" found.", sw, arg);
                }
                this.foundSwitches.put(sw, arg);
            } else {
                unswitchedArgsList.add(argv[i]);
            }
            ++i;
        }
        if (requiredSwitches != null) {
            i = 0;
            while (i < requiredSwitches.length) {
                if (!this.foundSwitches.containsKey(requiredSwitches[i])) {
                    throw new MissingSwitchException("Required switch \"" + requiredSwitches[i] + "\" not found.", requiredSwitches[i]);
                }
                ++i;
            }
        }
        this.unswitchedArgs = new String[unswitchedArgsList.size()];
        unswitchedArgsList.toArray(this.unswitchedArgs);
    }

    @Override
    public String getSwitchPrefix() {
        return this.switchPrefix;
    }

    @Override
    public String[] getRawArgs() {
        return (String[])this.argv.clone();
    }

    @Override
    public boolean includesSwitch(String sw) {
        return this.foundSwitches.containsKey(sw);
    }

    @Override
    public String getSwitchArg(String sw) {
        return (String)this.foundSwitches.get(sw);
    }

    @Override
    public String[] getUnswitchedArgs() {
        return (String[])this.unswitchedArgs.clone();
    }

    private static boolean contains(String string, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!list[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

