/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class BeanExtractingGeneratorExtension
implements GeneratorExtension {
    int ctor_modifiers = 1;
    int method_modifiers = 2;

    public void setConstructorModifiers(int ctor_modifiers) {
        this.ctor_modifiers = ctor_modifiers;
    }

    public int getConstructorModifiers() {
        return this.ctor_modifiers;
    }

    public void setExtractMethodModifiers(int method_modifiers) {
        this.method_modifiers = method_modifiers;
    }

    public int getExtractMethodModifiers() {
        return this.method_modifiers;
    }

    @Override
    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.beans.BeanInfo");
        set.add("java.beans.PropertyDescriptor");
        set.add("java.beans.Introspector");
        set.add("java.beans.IntrospectionException");
        set.add("java.lang.reflect.InvocationTargetException");
        return set;
    }

    @Override
    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw) throws IOException {
        iw.println("private static Class[] NOARGS = new Class[0];");
        iw.println();
        iw.print(CodegenUtils.getModifierString(this.method_modifiers));
        iw.print(" void extractPropertiesFromBean( Object bean ) throws InvocationTargetException, IllegalAccessException, IntrospectionException");
        iw.println("{");
        iw.upIndent();
        iw.println("BeanInfo bi = Introspector.getBeanInfo( bean.getClass() );");
        iw.println("PropertyDescriptor[] pds = bi.getPropertyDescriptors();");
        iw.println("for (int i = 0, len = pds.length; i < len; ++i)");
        iw.println("{");
        iw.upIndent();
        int i = 0;
        int len = props.length;
        while (i < len) {
            iw.println("if (\"" + props[i].getName() + "\".equals( pds[i].getName() ) )");
            iw.upIndent();
            iw.println("this." + props[i].getName() + " = " + this.extractorExpr(props[i], propTypes[i]) + ';');
            iw.downIndent();
            ++i;
        }
        iw.println("}");
        iw.downIndent();
        iw.println("}");
        iw.println();
        iw.print(CodegenUtils.getModifierString(this.ctor_modifiers));
        iw.println(String.valueOf(' ') + info.getClassName() + "( Object bean ) throws InvocationTargetException, IllegalAccessException, IntrospectionException");
        iw.println("{");
        iw.upIndent();
        iw.println("extractPropertiesFromBean( bean );");
        iw.downIndent();
        iw.println("}");
    }

    private String extractorExpr(Property prop, Class propType) {
        if (propType.isPrimitive()) {
            String castType = BeangenUtils.capitalize(prop.getSimpleTypeName());
            String valueMethod = String.valueOf(prop.getSimpleTypeName()) + "Value()";
            if (propType == Character.TYPE) {
                castType = "Character";
            } else if (propType == Integer.TYPE) {
                castType = "Integer";
            }
            return "((" + castType + ") pds[i].getReadMethod().invoke( bean, NOARGS ))." + valueMethod;
        }
        return "(" + prop.getSimpleTypeName() + ") pds[i].getReadMethod().invoke( bean, NOARGS )";
    }
}

