/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ExplicitPropsConstructorGeneratorExtension
implements GeneratorExtension {
    static final MLogger logger = MLog.getLogger(ExplicitPropsConstructorGeneratorExtension.class);
    String[] propNames;
    boolean skips_silently = false;
    int ctor_modifiers = 1;

    public ExplicitPropsConstructorGeneratorExtension() {
    }

    public ExplicitPropsConstructorGeneratorExtension(String[] propNames) {
        this.propNames = propNames;
    }

    public String[] getPropNames() {
        return (String[])this.propNames.clone();
    }

    public void setPropNames(String[] propNames) {
        this.propNames = (String[])propNames.clone();
    }

    public boolean isSkipsSilently() {
        return this.skips_silently;
    }

    public void setsSkipsSilently(boolean skips_silently) {
        this.skips_silently = skips_silently;
    }

    @Override
    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection extraSpecificImports() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw) throws IOException {
        HashMap<String, Property> propNamesToProps = new HashMap<String, Property>();
        int i = 0;
        int len = props.length;
        while (i < len) {
            propNamesToProps.put(props[i].getName(), props[i]);
            ++i;
        }
        ArrayList<Property> subPropsList = new ArrayList<Property>(this.propNames.length);
        int i2 = 0;
        int len2 = this.propNames.length;
        while (i2 < len2) {
            Property p = (Property)propNamesToProps.get(this.propNames[i2]);
            if (p == null) {
                logger.warning("Could not include property '" + this.propNames[i2] + "' in explicit-props-constructor generated for bean class '" + info.getClassName() + "' because the property is not defined for the bean. Skipping.");
            } else {
                subPropsList.add(p);
            }
            ++i2;
        }
        if (subPropsList.size() > 0) {
            Property[] subProps = subPropsList.toArray(new Property[subPropsList.size()]);
            iw.print(CodegenUtils.getModifierString(this.ctor_modifiers));
            iw.print(String.valueOf(info.getClassName()) + "( ");
            BeangenUtils.writeArgList(subProps, true, iw);
            iw.println(" )");
            iw.println("{");
            iw.upIndent();
            int i3 = 0;
            int len3 = subProps.length;
            while (i3 < len3) {
                iw.print("this." + subProps[i3].getName() + " = ");
                String setExp = subProps[i3].getDefensiveCopyExpression();
                if (setExp == null) {
                    setExp = subProps[i3].getName();
                }
                iw.println(String.valueOf(setExp) + ';');
                ++i3;
            }
            iw.downIndent();
            iw.println("}");
        }
    }
}

