/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.csv;

import com.mchange.v2.csv.FastCsvUtils;
import com.mchange.v2.csv.MalformedCsvException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.stream.Stream;

public class CsvBufferedReader
extends BufferedReader {
    private BufferedReader inner;

    public CsvBufferedReader(BufferedReader inner) {
        super(inner);
        this.inner = inner;
    }

    @Override
    public String readLine() throws IOException {
        try {
            return FastCsvUtils.csvReadLine(this.inner);
        }
        catch (MalformedCsvException e) {
            throw new IOException("Badly formatted CSV file.", e);
        }
    }

    public String[] readSplitLine() throws IOException, MalformedCsvException {
        String line = this.readLine();
        return line == null ? null : FastCsvUtils.splitRecord(line);
    }

    @Override
    public int read() throws IOException {
        return this.inner.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.inner.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inner.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.inner.ready();
    }

    @Override
    public boolean markSupported() {
        return this.inner.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.inner.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.inner.reset();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public Stream<String> lines() {
        throw new UnsupportedOperationException("lines() not yet implemented for CsvBufferedReader!");
    }
}

