/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.csv;

import com.mchange.v2.csv.MalformedCsvException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FastCsvUtils {
    private static final int ESCAPE_BIT = 0x1000000;
    private static final int SHIFT_BIT = 0x2000000;
    private static final int SHIFT_OFFSET = 8;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int EOF = -1;
    private static final int CRLF_TOKEN = 999;
    private static final String CRLF = "\r\n";
    private static final int GUESSED_LINE_LEN = 512;

    public static String csvReadLine(BufferedReader br) throws IOException, MalformedCsvException {
        String out;
        int[] holder = new int[1];
        String s = FastCsvUtils.readLine(br, holder);
        if (s != null) {
            int quoteCount = FastCsvUtils.countQuotes(s);
            if (quoteCount % 2 != 0) {
                StringBuilder sb = new StringBuilder(s);
                do {
                    FastCsvUtils.appendForToken(holder[0], sb);
                    s = FastCsvUtils.readLine(br, holder);
                    if (s == null) {
                        throw new MalformedCsvException("Unterminated quote at EOF: '" + sb.toString() + "'");
                    }
                    sb.append(s);
                } while ((quoteCount += FastCsvUtils.countQuotes(s)) % 2 != 0);
                out = sb.toString();
            } else {
                out = s;
            }
        } else {
            out = null;
        }
        return out;
    }

    private static void appendForToken(int token, StringBuilder sb) {
        switch (token) {
            case 10: 
            case 13: {
                sb.append((char)token);
                break;
            }
            case 999: {
                sb.append(CRLF);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new InternalError("Unexpected token (should never happen): " + token);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String readLine(BufferedReader br, int[] outSep) throws IOException {
        sb = new StringBuilder(512);
        i = br.read();
        if (i >= 0) ** GOTO lbl9
        outSep[0] = -1;
        return null;
lbl-1000:
        // 1 sources

        {
            sb.append((char)i);
            i = br.read();
lbl9:
            // 2 sources

            ** while (FastCsvUtils.notSepOrEOF((int)i))
        }
lbl10:
        // 1 sources

        if (i == 13) {
            br.mark(1);
            check = br.read();
            if (check == 10) {
                outSep[0] = 999;
            } else {
                br.reset();
                outSep[0] = 13;
            }
        } else {
            outSep[0] = i;
        }
        return sb.toString();
    }

    private static boolean notSepOrEOF(int i) {
        return i >= 0 && i != 10 && i != 13;
    }

    private static int countQuotes(String s) {
        char[] chars = s.toCharArray();
        int count = 0;
        int i = 0;
        int len = chars.length;
        while (i < len) {
            if (chars[i] == '\"') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String[] splitRecord(String csvRecord) throws MalformedCsvException {
        int[] upshifted = FastCsvUtils.upshiftQuoteString(csvRecord);
        List upshiftedSplit = FastCsvUtils.splitShifted(upshifted);
        int len = upshiftedSplit.size();
        String[] out = new String[len];
        int i = 0;
        while (i < len) {
            out[i] = FastCsvUtils.downshift((int[])upshiftedSplit.get(i));
            ++i;
        }
        return out;
    }

    private static void debugPrint(int[] arr) {
        int len = arr.length;
        char[] cbuf = new char[len];
        int i = 0;
        while (i < len) {
            cbuf[i] = (char)(FastCsvUtils.isShifted(arr[i]) ? 95 : (char)arr[i]);
            ++i;
        }
        System.err.println(new String(cbuf));
    }

    private static List splitShifted(int[] shiftedQuoteString) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        int sstart = 0;
        int finger = 0;
        int len = shiftedQuoteString.length;
        while (finger <= len) {
            if (finger == len || shiftedQuoteString[finger] == 44) {
                int tlen = -1;
                int tstart = sstart;
                while (tstart <= finger) {
                    if (tstart == finger) {
                        tlen = 0;
                        break;
                    }
                    if (shiftedQuoteString[tstart] != 32 && shiftedQuoteString[tstart] != 9) break;
                    ++tstart;
                }
                if (tlen < 0) {
                    if (tstart == finger - 1) {
                        tlen = 1;
                    } else {
                        tlen = finger - tstart;
                        while (tlen > 0) {
                            int index = tstart + tlen - 1;
                            if (shiftedQuoteString[index] != 32 && shiftedQuoteString[index] != 9) break;
                            --tlen;
                        }
                    }
                }
                int[] trimsplit = new int[tlen];
                if (tlen > 0) {
                    System.arraycopy(shiftedQuoteString, tstart, trimsplit, 0, tlen);
                }
                out.add(trimsplit);
                sstart = finger + 1;
            }
            ++finger;
        }
        return out;
    }

    private static String downshift(int[] maybeShifted) {
        int len = maybeShifted.length;
        char[] cbuf = new char[len];
        int i = 0;
        while (i < len) {
            int c = maybeShifted[i];
            cbuf[i] = (char)(FastCsvUtils.isShifted(c) ? c >>> 8 : c);
            ++i;
        }
        return new String(cbuf);
    }

    private static boolean isShifted(int c) {
        return (c & 0x2000000) != 0;
    }

    private static int[] upshiftQuoteString(String s) throws MalformedCsvException {
        char[] chars = s.toCharArray();
        int[] buf = new int[chars.length];
        EscapedCharReader rdr = new EscapedCharReader(chars);
        int finger = 0;
        boolean shift = false;
        int c = rdr.read(shift);
        while (c >= 0) {
            if (c == 34) {
                shift = !shift;
            } else {
                buf[finger++] = FastCsvUtils.findShiftyChar(c, shift);
            }
            c = rdr.read(shift);
        }
        int[] out = new int[finger];
        System.arraycopy(buf, 0, out, 0, finger);
        return out;
    }

    private static int findShiftyChar(int c, boolean shift) {
        return shift ? c << 8 | 0x2000000 : c;
    }

    private static int escape(int c) {
        return c | 0x1000000;
    }

    private static boolean isEscaped(int c) {
        return (c & 0x1000000) != 0;
    }

    private FastCsvUtils() {
    }

    private static class EscapedCharReader {
        char[] chars;
        int finger;

        EscapedCharReader(char[] chars) {
            this.chars = chars;
            this.finger = 0;
        }

        int read(boolean shift) throws MalformedCsvException {
            if (this.finger < this.chars.length) {
                char out;
                if ((out = this.chars[this.finger++]) == '\"' && shift) {
                    if (this.finger < this.chars.length) {
                        char next = this.chars[this.finger];
                        if (next == '\"') {
                            ++this.finger;
                            return FastCsvUtils.escape(next);
                        }
                        return out;
                    }
                    return out;
                }
                return out;
            }
            return -1;
        }
    }
}

