/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Coerce {
    static final Set CAN_COERCE;

    static {
        Class[] classes = new Class[]{Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, String.class, Byte.class, Boolean.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        HashSet<Class> tmp = new HashSet<Class>();
        tmp.addAll(Arrays.asList(classes));
        CAN_COERCE = Collections.unmodifiableSet(tmp);
    }

    public static boolean canCoerce(Class cl) {
        return CAN_COERCE.contains(cl);
    }

    public static boolean canCoerce(Object o) {
        return Coerce.canCoerce(o.getClass());
    }

    public static int toInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return (int)Double.parseDouble(s);
        }
    }

    public static long toLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return (long)Double.parseDouble(s);
        }
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s);
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s);
    }

    public static byte toByte(String s) {
        return (byte)Coerce.toInt(s);
    }

    public static short toShort(String s) {
        return (short)Coerce.toInt(s);
    }

    public static boolean toBoolean(String s) {
        return Boolean.valueOf(s);
    }

    public static char toChar(String s) {
        if ((s = s.trim()).length() == 1) {
            return s.charAt(0);
        }
        return (char)Coerce.toInt(s);
    }

    public static Object toObject(String s, Class type) {
        if (type == Byte.TYPE) {
            type = Byte.class;
        } else if (type == Boolean.TYPE) {
            type = Boolean.class;
        } else if (type == Character.TYPE) {
            type = Character.class;
        } else if (type == Short.TYPE) {
            type = Short.class;
        } else if (type == Integer.TYPE) {
            type = Integer.class;
        } else if (type == Long.TYPE) {
            type = Long.class;
        } else if (type == Float.TYPE) {
            type = Float.class;
        } else if (type == Double.TYPE) {
            type = Double.class;
        }
        if (type == String.class) {
            return s;
        }
        if (type == Byte.class) {
            return new Byte(Coerce.toByte(s));
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(s);
        }
        if (type == Character.class) {
            return new Character(Coerce.toChar(s));
        }
        if (type == Short.class) {
            return new Short(Coerce.toShort(s));
        }
        if (type == Integer.class) {
            return new Integer(s);
        }
        if (type == Long.class) {
            return new Long(s);
        }
        if (type == Float.class) {
            return new Float(s);
        }
        if (type == Double.class) {
            return new Double(s);
        }
        throw new IllegalArgumentException("Cannot coerce to type: " + type.getName());
    }

    private Coerce() {
    }
}

