/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SystemUtils {
    private static final Pattern REPLACE_ME_REGEX = Pattern.compile("(?<!\\$)\\$\\{\\s*(.+?)\\s*\\}");
    private static final Pattern UNESCAPE_ME_REGEX = Pattern.compile("\\$\\$\\{\\s*(.+?)\\s*\\}");

    private static String _unescape(String replaced) {
        Matcher m = UNESCAPE_ME_REGEX.matcher(replaced);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replacement = String.valueOf('\\') + m.group(0).substring(1);
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String _mapReplace(String source, Map<String, String> replacements) {
        Matcher m = REPLACE_ME_REGEX.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replacement = replacements.get(m.group(1));
            if (replacement == null) continue;
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static Map<String, String> propsMap() {
        return Collections.checkedMap(System.getProperties(), String.class, String.class);
    }

    public static String mapReplace(String source, Map<String, String> replacements) {
        return SystemUtils._unescape(SystemUtils._mapReplace(source, replacements));
    }

    public static String sysPropsReplace(String source) {
        return SystemUtils.mapReplace(source, SystemUtils.propsMap());
    }

    public static String envReplace(String source) {
        return SystemUtils.mapReplace(source, System.getenv());
    }

    public static String sysPropsEnvReplace(String source) {
        String halfway = SystemUtils._mapReplace(source, SystemUtils.propsMap());
        return SystemUtils.envReplace(halfway);
    }

    private SystemUtils() {
    }
}

