/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;

public final class VersionUtils {
    private static final MLogger logger;
    private static final int[] DFLT_VERSION_ARRAY;
    private static final int[] JDK_VERSION_ARRAY;
    private static final int JDK_VERSION;
    private static final Integer NUM_BITS;

    static {
        Integer tmpNumBits;
        int jdkv;
        int[] v;
        logger = MLog.getLogger(VersionUtils.class);
        DFLT_VERSION_ARRAY = new int[]{1, 1};
        String vstr = System.getProperty("java.version");
        if (vstr == null) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Could not find java.version System property. Defaulting to JDK 1.1");
            }
            v = DFLT_VERSION_ARRAY;
        } else {
            try {
                v = VersionUtils.extractVersionNumberArray(vstr);
            }
            catch (NumberFormatException numberFormatException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("java.version \"" + vstr + "\" could not be parsed. Defaulting to JDK 1.1.");
                }
                v = DFLT_VERSION_ARRAY;
            }
        }
        if (v.length == 0) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("java.version \"" + vstr + "\" is prefixed by no integral elements. Defaulting to JDK 1.1.");
            }
            v = DFLT_VERSION_ARRAY;
        }
        if (v[0] > 1) {
            jdkv = v[0];
        } else if (v[0] == 1) {
            if (v.length > 1) {
                jdkv = v[1];
            } else {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("java.version \"" + vstr + "\" looks like a 1.x style bargain, but the second element cannot be parsed. Defaulting to JDK 1.1.");
                }
                jdkv = 1;
            }
        } else {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Illegal java.version \"" + vstr + "\". Defaulting to JDK 1.1.");
            }
            jdkv = 1;
        }
        JDK_VERSION_ARRAY = v;
        JDK_VERSION = jdkv;
        try {
            String numBitsStr = System.getProperty("sun.arch.data.model");
            tmpNumBits = numBitsStr == null ? null : new Integer(numBitsStr);
        }
        catch (Exception exception) {
            tmpNumBits = null;
        }
        if (tmpNumBits == null || tmpNumBits == 32 || tmpNumBits == 64) {
            NUM_BITS = tmpNumBits;
        } else {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Determined a surprising jvmNumerOfBits: " + tmpNumBits + ". Setting jvmNumberOfBits to unknown (null).");
            }
            NUM_BITS = null;
        }
    }

    public static Integer jvmNumberOfBits() {
        return NUM_BITS;
    }

    public static boolean isJavaVersion1_0() {
        return JDK_VERSION == 0;
    }

    public static boolean isJavaVersion1_1() {
        return JDK_VERSION == 1;
    }

    public static boolean isJavaVersion1_2() {
        return JDK_VERSION == 2;
    }

    public static boolean isJavaVersion1_3() {
        return JDK_VERSION == 3;
    }

    public static boolean isJavaVersion1_4() {
        return JDK_VERSION == 4;
    }

    public static boolean isJavaVersion1_5() {
        return JDK_VERSION == 5;
    }

    public static boolean isJavaVersion1_6() {
        return JDK_VERSION == 6;
    }

    public static boolean isJavaVersion1_7() {
        return JDK_VERSION == 7;
    }

    public static boolean isJavaVersion1_8() {
        return JDK_VERSION == 8;
    }

    public static boolean isJavaVersion1_9() {
        return JDK_VERSION == 9;
    }

    public static boolean isJava5() {
        return JDK_VERSION == 5;
    }

    public static boolean isJava6() {
        return JDK_VERSION == 6;
    }

    public static boolean isJava7() {
        return JDK_VERSION == 7;
    }

    public static boolean isJava8() {
        return JDK_VERSION == 8;
    }

    public static boolean isJava9() {
        return JDK_VERSION == 9;
    }

    public static boolean isJava10() {
        return JDK_VERSION == 10;
    }

    public static boolean isJava11() {
        return JDK_VERSION == 11;
    }

    public static boolean isJava12() {
        return JDK_VERSION == 12;
    }

    public static boolean isJava13() {
        return JDK_VERSION == 13;
    }

    public static boolean isAtLeastJavaVersion1_0() {
        return JDK_VERSION >= 0;
    }

    public static boolean isAtLeastJavaVersion1_1() {
        return JDK_VERSION >= 1;
    }

    public static boolean isAtLeastJavaVersion1_2() {
        return JDK_VERSION >= 2;
    }

    public static boolean isAtLeastJavaVersion1_3() {
        return JDK_VERSION >= 3;
    }

    public static boolean isAtLeastJavaVersion1_4() {
        return JDK_VERSION >= 4;
    }

    public static boolean isAtLeastJavaVersion1_5() {
        return JDK_VERSION >= 5;
    }

    public static boolean isAtLeastJavaVersion1_6() {
        return JDK_VERSION >= 6;
    }

    public static boolean isAtLeastJavaVersion1_7() {
        return JDK_VERSION >= 7;
    }

    public static boolean isAtLeastJavaVersion1_8() {
        return JDK_VERSION >= 8;
    }

    public static boolean isAtLeastJavaVersion1_9() {
        return JDK_VERSION >= 9;
    }

    public static boolean isAtLeastJava5() {
        return JDK_VERSION >= 5;
    }

    public static boolean isAtLeastJava6() {
        return JDK_VERSION >= 6;
    }

    public static boolean isAtLeastJava7() {
        return JDK_VERSION >= 7;
    }

    public static boolean isAtLeastJava8() {
        return JDK_VERSION >= 8;
    }

    public static boolean isAtLeastJava9() {
        return JDK_VERSION >= 9;
    }

    public static boolean isAtLeastJava10() {
        return JDK_VERSION >= 10;
    }

    public static boolean isAtLeastJava11() {
        return JDK_VERSION >= 11;
    }

    public static boolean isAtLeastJava12() {
        return JDK_VERSION >= 12;
    }

    public static boolean isAtLeastJava13() {
        return JDK_VERSION >= 13;
    }

    public static boolean isJavaVersion10() {
        return JDK_VERSION == 0;
    }

    public static boolean isJavaVersion11() {
        return JDK_VERSION == 1;
    }

    public static boolean isJavaVersion12() {
        return JDK_VERSION == 2;
    }

    public static boolean isJavaVersion13() {
        return JDK_VERSION == 3;
    }

    public static boolean isJavaVersion14() {
        return JDK_VERSION == 4;
    }

    public static boolean isJavaVersion15() {
        return JDK_VERSION == 5;
    }

    public static boolean isAtLeastJavaVersion10() {
        return JDK_VERSION >= 0;
    }

    public static boolean isAtLeastJavaVersion11() {
        return JDK_VERSION >= 1;
    }

    public static boolean isAtLeastJavaVersion12() {
        return JDK_VERSION >= 2;
    }

    public static boolean isAtLeastJavaVersion13() {
        return JDK_VERSION >= 3;
    }

    public static boolean isAtLeastJavaVersion14() {
        return JDK_VERSION >= 4;
    }

    public static boolean isAtLeastJavaVersion15() {
        return JDK_VERSION >= 5;
    }

    public static boolean isAtLeastJavaVersion16() {
        return JDK_VERSION >= 6;
    }

    public static boolean isAtLeastJavaVersion17() {
        return JDK_VERSION >= 7;
    }

    public static int[] extractVersionNumberArray(String versionString) throws NumberFormatException {
        return VersionUtils.extractVersionNumberArray(versionString, versionString.split("\\D+"));
    }

    public static int[] extractVersionNumberArray(String versionString, String delims) throws NumberFormatException {
        String[] intStrs = StringTokenizerUtils.tokenizeToArray(versionString, delims, false);
        return VersionUtils.extractVersionNumberArray(versionString, intStrs);
    }

    private static int[] extractVersionNumberArray(String versionString, String[] intStrs) throws NumberFormatException {
        int len = intStrs.length;
        int[] out = new int[len];
        int i = 0;
        while (i < len) {
            try {
                out[i] = Integer.parseInt(intStrs[i]);
            }
            catch (NumberFormatException e) {
                if (i == 0 || i == 1 && out[0] < 5) {
                    throw e;
                }
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "JVM version string (" + versionString + ") contains non-integral component (" + intStrs[i] + "). Using precending components only to resolve JVM version.");
                }
                int[] goodEnough = new int[i];
                System.arraycopy(out, 0, goodEnough, 0, i);
                out = goodEnough;
                break;
            }
            ++i;
        }
        return out;
    }
}

