/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.jdk14logging.Jdk14LoggingUtils;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.LogRecord;

public final class FallbackMLog
extends MLog {
    static final MLevel DEFAULT_CUTOFF_LEVEL;
    static final String SEP;
    private static MLevel overrideCutoffLevel;
    private static Filter globalFilter;
    private final MLogger nameless = new FallbackMLogger();

    static {
        overrideCutoffLevel = null;
        globalFilter = null;
        MLevel dflt = null;
        String dfltName = MLogConfig.getProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL");
        if (dfltName != null) {
            dflt = MLevel.fromSeverity(dfltName);
        }
        if (dflt == null) {
            dflt = MLevel.INFO;
        }
        DEFAULT_CUTOFF_LEVEL = dflt;
        SEP = System.getProperty("line.separator");
    }

    public synchronized MLevel cutoffLevel() {
        if (overrideCutoffLevel != null) {
            return overrideCutoffLevel;
        }
        return DEFAULT_CUTOFF_LEVEL;
    }

    public void overrideCutoffLevel(MLevel level) {
        this.setOverrideCutoffLevel(level);
    }

    public synchronized void setOverrideCutoffLevel(MLevel level) {
        overrideCutoffLevel = level;
    }

    public synchronized MLevel getOverrideCutoffLevel() {
        return overrideCutoffLevel;
    }

    private static Filter filterFromObject(Object o) {
        if (o instanceof Filter) {
            return (Filter)o;
        }
        if (o instanceof java.util.logging.Filter) {
            return new Jdk14FilterAdapter((java.util.logging.Filter)o);
        }
        throw new IllegalArgumentException("Provided filter " + o + " must be either a FallbackMLog.Filter or an instance of java.util.logging.Filter.");
    }

    public synchronized void setGlobalFilter(Object filter) {
        globalFilter = FallbackMLog.filterFromObject(filter);
    }

    public synchronized Object getGlobalFilter() {
        if (globalFilter instanceof Jdk14FilterAdapter) {
            return ((Jdk14FilterAdapter)globalFilter).getInner();
        }
        return globalFilter;
    }

    private synchronized Filter _getGlobalFilter() {
        return globalFilter;
    }

    @Override
    public MLogger getMLogger(String name) {
        return new FallbackMLogger(name);
    }

    @Override
    public MLogger getMLogger() {
        return this.nameless;
    }

    private final class FallbackMLogger
    implements MLogger {
        String name;
        Filter filter = null;

        public FallbackMLogger(String name) {
            this.name = name;
        }

        public FallbackMLogger() {
            this.name = null;
        }

        private void formatrb(MLevel l, String srcClass, String srcMeth, String rbname, String msg, Object[] params, Throwable t) {
            String check;
            ResourceBundle rb = ResourceBundle.getBundle(rbname);
            if (msg != null && rb != null && (check = rb.getString(msg)) != null) {
                msg = check;
            }
            this.format(l, srcClass, srcMeth, msg, params, t);
        }

        private boolean isLoggableMessage(MLevel l, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            boolean globalOkay;
            Filter globalFilter = FallbackMLog.this._getGlobalFilter();
            boolean bl = globalOkay = globalFilter == null || globalFilter.isLoggable(l, this.name, srcClass, srcMeth, msg, params, t);
            if (globalOkay) {
                Filter localFilter = this._getFilter();
                boolean localOkay = localFilter == null || localFilter.isLoggable(l, this.name, srcClass, srcMeth, msg, params, t);
                return localOkay;
            }
            return false;
        }

        private void format(MLevel l, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            if (this.isLoggableMessage(l, srcClass, srcMeth, msg, params, t)) {
                System.err.println(this.formatString(l, srcClass, srcMeth, msg, params, t));
            }
        }

        private String formatString(MLevel l, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            boolean add_parens = srcMeth != null && !srcMeth.endsWith(")");
            StringBuffer sb = new StringBuffer(256);
            sb.append(l.getLineHeader());
            sb.append(' ');
            if (this.name != null) {
                sb.append(this.name);
                sb.append(' ');
            }
            if (srcClass != null && srcMeth != null) {
                sb.append('[');
                sb.append(srcClass);
                sb.append('.');
                sb.append(srcMeth);
                if (add_parens) {
                    sb.append("()");
                }
                sb.append(']');
            } else if (srcClass != null) {
                sb.append('[');
                sb.append(srcClass);
                sb.append(']');
            } else if (srcMeth != null) {
                sb.append('[');
                sb.append(srcMeth);
                if (add_parens) {
                    sb.append("()");
                }
                sb.append(']');
            }
            if (msg == null) {
                if (params != null) {
                    sb.append("params: ");
                    int i = 0;
                    int len = params.length;
                    while (i < len) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(params[i]);
                        ++i;
                    }
                }
            } else if (params == null) {
                sb.append(msg);
            } else {
                MessageFormat mfmt = new MessageFormat(msg);
                sb.append(mfmt.format(params));
            }
            if (t != null) {
                sb.append(SEP);
                sb.append(ThrowableUtils.extractStackTrace(t));
            }
            return sb.toString();
        }

        @Override
        public ResourceBundle getResourceBundle() {
            return null;
        }

        @Override
        public String getResourceBundleName() {
            return null;
        }

        @Override
        public synchronized void setFilter(Object filter) {
            this.filter = FallbackMLog.filterFromObject(filter);
        }

        @Override
        public synchronized Object getFilter() {
            if (this.filter instanceof Jdk14FilterAdapter) {
                return ((Jdk14FilterAdapter)this.filter).getInner();
            }
            return this.filter;
        }

        private synchronized Filter _getFilter() {
            return this.filter;
        }

        @Override
        public void log(MLevel l, String msg) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, null, null);
            }
        }

        @Override
        public void log(MLevel l, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, new Object[]{param}, null);
            }
        }

        @Override
        public void log(MLevel l, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, params, null);
            }
        }

        @Override
        public void log(MLevel l, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, null, t);
            }
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, null, null);
            }
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, new Object[]{param}, null);
            }
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, params, null);
            }
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, null, t);
            }
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, null, null);
            }
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, new Object[]{param}, null);
            }
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, params, null);
            }
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, null, t);
            }
        }

        @Override
        public void entering(String srcClass, String srcMeth) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Entering method.", null, null);
            }
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object param) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Entering method with argument " + param, null, null);
            }
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object[] params) {
            if (this.isLoggable(MLevel.FINER)) {
                if (params == null) {
                    this.entering(srcClass, srcMeth);
                } else {
                    StringBuffer sb = new StringBuffer(128);
                    sb.append("( ");
                    int i = 0;
                    int len = params.length;
                    while (i < len) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(params[i]);
                        ++i;
                    }
                    sb.append(" )");
                    this.format(MLevel.FINER, srcClass, srcMeth, "Entering method with arguments " + sb.toString(), null, null);
                }
            }
        }

        @Override
        public void exiting(String srcClass, String srcMeth) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Exiting method.", null, null);
            }
        }

        @Override
        public void exiting(String srcClass, String srcMeth, Object result) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Exiting method with result " + result, null, null);
            }
        }

        @Override
        public void throwing(String srcClass, String srcMeth, Throwable t) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, srcClass, srcMeth, "Throwing exception.", null, t);
            }
        }

        @Override
        public void severe(String msg) {
            if (this.isLoggable(MLevel.SEVERE)) {
                this.format(MLevel.SEVERE, null, null, msg, null, null);
            }
        }

        @Override
        public void warning(String msg) {
            if (this.isLoggable(MLevel.WARNING)) {
                this.format(MLevel.WARNING, null, null, msg, null, null);
            }
        }

        @Override
        public void info(String msg) {
            if (this.isLoggable(MLevel.INFO)) {
                this.format(MLevel.INFO, null, null, msg, null, null);
            }
        }

        @Override
        public void config(String msg) {
            if (this.isLoggable(MLevel.CONFIG)) {
                this.format(MLevel.CONFIG, null, null, msg, null, null);
            }
        }

        @Override
        public void fine(String msg) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, null, null, msg, null, null);
            }
        }

        @Override
        public void finer(String msg) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, null, null, msg, null, null);
            }
        }

        @Override
        public void finest(String msg) {
            if (this.isLoggable(MLevel.FINEST)) {
                this.format(MLevel.FINEST, null, null, msg, null, null);
            }
        }

        @Override
        public void setLevel(MLevel l) throws SecurityException {
            FallbackMLog.this.overrideCutoffLevel(l);
        }

        @Override
        public synchronized MLevel getLevel() {
            return FallbackMLog.this.cutoffLevel();
        }

        @Override
        public synchronized boolean isLoggable(MLevel l) {
            return l.intValue() >= FallbackMLog.this.cutoffLevel().intValue();
        }

        @Override
        public String getName() {
            return "global";
        }

        @Override
        public void addHandler(Object h) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public void removeHandler(Object h) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public Object[] getHandlers() {
            this.warning("Using FallbackMLog -- Handlers not supported.");
            return new Object[0];
        }

        @Override
        public void setUseParentHandlers(boolean uph) {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        @Override
        public boolean getUseParentHandlers() {
            return false;
        }
    }

    public static interface Filter {
        public boolean isLoggable(MLevel var1, String var2, String var3, String var4, String var5, Object[] var6, Throwable var7);
    }

    private static class Jdk14FilterAdapter
    implements Filter {
        private java.util.logging.Filter julFilter;

        Jdk14FilterAdapter(java.util.logging.Filter julFilter) {
            this.julFilter = julFilter;
        }

        java.util.logging.Filter getInner() {
            return this.julFilter;
        }

        @Override
        public boolean isLoggable(MLevel level, String loggerName, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            LogRecord lr = new LogRecord(Jdk14LoggingUtils.levelFromMLevel(level), msg);
            lr.setLoggerName(loggerName);
            lr.setSourceClassName(srcClass);
            lr.setSourceMethodName(srcMeth);
            lr.setParameters(params);
            lr.setThrown(t);
            return this.julFilter.isLoggable(lr);
        }
    }
}

