/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class LogUtils {
    public static String createParamsList(Object[] params) {
        StringBuffer sb = new StringBuffer(511);
        LogUtils.appendParamsList(sb, params);
        return sb.toString();
    }

    public static void appendParamsList(StringBuffer sb, Object[] params) {
        sb.append("[params: ");
        if (params != null) {
            int i = 0;
            int len = params.length;
            while (i < len) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(params[i]);
                ++i;
            }
        }
        sb.append(']');
    }

    public static String createMessage(String srcClass, String srcMeth, String msg) {
        StringBuffer sb = new StringBuffer(511);
        sb.append("[class: ");
        sb.append(srcClass);
        sb.append("; method: ");
        sb.append(srcMeth);
        if (!srcMeth.endsWith(")")) {
            sb.append("()");
        }
        sb.append("] ");
        sb.append(msg);
        return sb.toString();
    }

    public static String createMessage(String srcMeth, String msg) {
        StringBuffer sb = new StringBuffer(511);
        sb.append("[method: ");
        sb.append(srcMeth);
        if (!srcMeth.endsWith(")")) {
            sb.append("()");
        }
        sb.append("] ");
        sb.append(msg);
        return sb.toString();
    }

    public static String formatMessage(String rbname, String msg, Object[] params) {
        String check;
        ResourceBundle rb;
        if (msg == null) {
            if (params == null) {
                return "";
            }
            return LogUtils.createParamsList(params);
        }
        if (rbname != null && (rb = ResourceBundle.getBundle(rbname)) != null && (check = rb.getString(msg)) != null) {
            msg = check;
        }
        return params == null ? msg : MessageFormat.format(msg, params);
    }

    private LogUtils() {
    }
}

