/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.ResourceBundle;

final class RedirectableMLogger
implements MLogger {
    private static HashSet weakRefSet = new HashSet();
    private String _name;
    private MLogger _inner;

    static synchronized RedirectableMLogger wrap(MLogger mlogger) {
        RedirectableMLogger out = new RedirectableMLogger(mlogger);
        weakRefSet.add(new WeakReference<RedirectableMLogger>(out));
        return out;
    }

    static synchronized void resetAll() {
        HashSet cloneSet = (HashSet)weakRefSet.clone();
        for (WeakReference wr : cloneSet) {
            RedirectableMLogger registered = (RedirectableMLogger)wr.get();
            if (registered == null) {
                weakRefSet.remove(wr);
                continue;
            }
            registered.reset();
        }
    }

    private synchronized void reset() {
        this._inner = null;
    }

    private synchronized MLogger inner() {
        if (this._inner == null) {
            this._inner = MLog.getLogger(this._name);
        }
        return this._inner;
    }

    private RedirectableMLogger(MLogger _inner) {
        this._inner = _inner;
        this._name = _inner.getName();
    }

    @Override
    public String getName() {
        return this.inner().getName();
    }

    @Override
    public void log(MLevel l, String msg) {
        this.inner().log(l, msg);
    }

    @Override
    public void log(MLevel l, String msg, Object param) {
        this.inner().log(l, msg, param);
    }

    @Override
    public void log(MLevel l, String msg, Object[] params) {
        this.inner().log(l, msg, params);
    }

    @Override
    public void log(MLevel l, String msg, Throwable t) {
        this.inner().log(l, msg, t);
    }

    @Override
    public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
        this.inner().logp(l, srcClass, srcMeth, msg);
    }

    @Override
    public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
        this.inner().logp(l, srcClass, srcMeth, msg, param);
    }

    @Override
    public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
        this.inner().logp(l, srcClass, srcMeth, msg, params);
    }

    @Override
    public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
        this.inner().logp(l, srcClass, srcMeth, msg, t);
    }

    @Override
    public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
        this.inner().logrb(l, srcClass, srcMeth, rb, msg);
    }

    @Override
    public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
        this.inner().logrb(l, srcClass, srcMeth, rb, msg, param);
    }

    @Override
    public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
        this.inner().logrb(l, srcClass, srcMeth, rb, msg, params);
    }

    @Override
    public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
        this.inner().logrb(l, srcClass, srcMeth, rb, msg, t);
    }

    @Override
    public void entering(String srcClass, String srcMeth) {
        this.inner().entering(srcClass, srcMeth);
    }

    @Override
    public void entering(String srcClass, String srcMeth, Object param) {
        this.inner().entering(srcClass, srcMeth, param);
    }

    @Override
    public void entering(String srcClass, String srcMeth, Object[] params) {
        this.inner().entering(srcClass, srcMeth, params);
    }

    @Override
    public void exiting(String srcClass, String srcMeth) {
        this.inner().exiting(srcClass, srcMeth);
    }

    @Override
    public void exiting(String srcClass, String srcMeth, Object result) {
        this.inner().exiting(srcClass, srcMeth, result);
    }

    @Override
    public void throwing(String srcClass, String srcMeth, Throwable t) {
        this.inner().throwing(srcClass, srcMeth, t);
    }

    @Override
    public void severe(String msg) {
        this.inner().severe(msg);
    }

    @Override
    public void warning(String msg) {
        this.inner().warning(msg);
    }

    @Override
    public void info(String msg) {
        this.inner().info(msg);
    }

    @Override
    public void config(String msg) {
        this.inner().config(msg);
    }

    @Override
    public void fine(String msg) {
        this.inner().fine(msg);
    }

    @Override
    public void finer(String msg) {
        this.inner().finer(msg);
    }

    @Override
    public void finest(String msg) {
        this.inner().finest(msg);
    }

    @Override
    public boolean isLoggable(MLevel l) {
        return this.inner().isLoggable(l);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.inner().getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return this.inner().getResourceBundleName();
    }

    @Override
    public void setFilter(Object java14Filter) throws SecurityException {
        this.inner().setFilter(java14Filter);
    }

    @Override
    public Object getFilter() {
        return this.inner().getFilter();
    }

    @Override
    public void setLevel(MLevel l) throws SecurityException {
        this.inner().setLevel(l);
    }

    @Override
    public MLevel getLevel() {
        return this.inner().getLevel();
    }

    @Override
    public void addHandler(Object h) throws SecurityException {
        this.inner().addHandler(h);
    }

    @Override
    public void removeHandler(Object h) throws SecurityException {
        this.inner().removeHandler(h);
    }

    @Override
    public Object[] getHandlers() {
        return this.inner().getHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean uph) {
        this.inner().setUseParentHandlers(uph);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.inner().getUseParentHandlers();
    }
}

