/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.slf4j;

import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.LogUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogInitializationException;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NullMLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Slf4jMLog
extends MLog {
    static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static final int ALL_INTVAL = MLevel.ALL.intValue();
    private static final int CONFIG_INTVAL = MLevel.CONFIG.intValue();
    private static final int FINE_INTVAL = MLevel.FINE.intValue();
    private static final int FINER_INTVAL = MLevel.FINER.intValue();
    private static final int FINEST_INTVAL = MLevel.FINEST.intValue();
    private static final int INFO_INTVAL = MLevel.INFO.intValue();
    private static final int OFF_INTVAL = MLevel.OFF.intValue();
    private static final int SEVERE_INTVAL = MLevel.SEVERE.intValue();
    private static final int WARNING_INTVAL = MLevel.WARNING.intValue();
    static final String CHECK_CLASS = "org.slf4j.LoggerFactory";
    static final String DFLT_LOGGER_NAME = "global";

    public Slf4jMLog() throws ClassNotFoundException, MLogInitializationException {
        Class.forName(CHECK_CLASS);
        ILoggerFactory ilf = LoggerFactory.getILoggerFactory();
        if (ilf == null || ilf.getClass().getName() == "org.slf4j.helpers.NOPLoggerFactory") {
            throw new MLogInitializationException("slf4j found no binding or threatened to use its (dangerously silent) NOPLogger. We consider the slf4j library not found.");
        }
    }

    @Override
    public MLogger getMLogger(String name) {
        Logger lg = LoggerFactory.getLogger((String)name);
        if (lg == null) {
            this.fallbackWarn(" with name '" + name + "'");
            return NullMLogger.instance();
        }
        return new Slf4jMLogger(lg);
    }

    @Override
    public MLogger getMLogger() {
        Logger lg = LoggerFactory.getLogger((String)DFLT_LOGGER_NAME);
        if (lg == null) {
            this.fallbackWarn(" (default, with name 'global')");
            return NullMLogger.instance();
        }
        return new Slf4jMLogger(lg);
    }

    private void fallbackWarn(String subst) {
        FallbackMLog.getLogger().warning("Could not create or find slf4j Logger" + subst + ". " + "Using NullMLogger. All messages sent to this" + "logger will be silently ignored. You might want to fix this.");
    }

    private static final class Slf4jMLogger
    implements MLogger {
        static final String FQCN = Slf4jMLogger.class.getName();
        final Logger logger;
        final LevelLogger traceL;
        final LevelLogger debugL;
        final LevelLogger infoL;
        final LevelLogger warnL;
        final LevelLogger errorL;
        final LevelLogger offL;
        MLevel myLevel = null;

        Slf4jMLogger(Logger logger) {
            this.logger = logger;
            this.traceL = new TraceLogger();
            this.debugL = new DebugLogger();
            this.infoL = new InfoLogger();
            this.warnL = new WarnLogger();
            this.errorL = new ErrorLogger();
            this.offL = new OffLogger();
        }

        private MLevel guessMLevel() {
            if (this.logger.isTraceEnabled()) {
                return MLevel.FINEST;
            }
            if (this.logger.isDebugEnabled()) {
                return MLevel.FINER;
            }
            if (this.logger.isInfoEnabled()) {
                return MLevel.INFO;
            }
            if (this.logger.isWarnEnabled()) {
                return MLevel.WARNING;
            }
            if (this.logger.isErrorEnabled()) {
                return MLevel.SEVERE;
            }
            return MLevel.OFF;
        }

        private synchronized boolean myLevelMayBeLoggable(int intval) {
            return this.myLevel == null || intval >= this.myLevel.intValue();
        }

        private LevelLogger levelLogger(MLevel l) {
            LevelLogger outL = this.offL;
            int n = l.intValue();
            if (this.myLevelMayBeLoggable(n) && n >= FINEST_INTVAL) {
                if (n < FINER_INTVAL) {
                    if (this.logger.isTraceEnabled()) {
                        outL = this.traceL;
                    }
                } else if (n < INFO_INTVAL) {
                    if (this.logger.isDebugEnabled()) {
                        outL = this.debugL;
                    }
                } else if (n < WARNING_INTVAL) {
                    if (this.logger.isInfoEnabled()) {
                        outL = this.infoL;
                    }
                } else if (n < SEVERE_INTVAL) {
                    if (this.logger.isWarnEnabled()) {
                        outL = this.warnL;
                    }
                } else if (n < OFF_INTVAL && this.logger.isErrorEnabled()) {
                    outL = this.errorL;
                }
            }
            return outL;
        }

        @Override
        public ResourceBundle getResourceBundle() {
            return null;
        }

        @Override
        public String getResourceBundleName() {
            return null;
        }

        @Override
        public void setFilter(Object java14Filter) throws SecurityException {
            this.warning("setFilter() not supported by MLogger " + this.getClass().getName());
        }

        @Override
        public Object getFilter() {
            return null;
        }

        @Override
        public void log(MLevel l, String msg) {
            this.levelLogger(l).log(msg);
        }

        @Override
        public void log(MLevel l, String msg, Object param) {
            this.levelLogger(l).log(msg, param);
        }

        @Override
        public void log(MLevel l, String msg, Object[] params) {
            this.levelLogger(l).log(msg, params);
        }

        @Override
        public void log(MLevel l, String msg, Throwable t) {
            this.levelLogger(l).log(msg, t);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, msg));
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, msg != null ? MessageFormat.format(msg, param) : null));
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, msg != null ? MessageFormat.format(msg, params) : null));
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, msg), t);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, LogUtils.formatMessage(rb, msg, null)));
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, LogUtils.formatMessage(rb, msg, new Object[]{param})));
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, LogUtils.formatMessage(rb, msg, params)));
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            this.levelLogger(l).log(LogUtils.createMessage(srcClass, srcMeth, LogUtils.formatMessage(rb, msg, null)), t);
        }

        @Override
        public void entering(String srcClass, String srcMeth) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "entering method."));
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object param) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "entering method... param: " + param.toString()));
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object[] params) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "entering method... " + LogUtils.createParamsList(params)));
        }

        @Override
        public void exiting(String srcClass, String srcMeth) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "exiting method."));
        }

        @Override
        public void exiting(String srcClass, String srcMeth, Object result) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "exiting method... result: " + result.toString()));
        }

        @Override
        public void throwing(String srcClass, String srcMeth, Throwable t) {
            this.traceL.log(LogUtils.createMessage(srcClass, srcMeth, "throwing exception... "), t);
        }

        @Override
        public void severe(String msg) {
            this.errorL.log(msg);
        }

        @Override
        public void warning(String msg) {
            this.warnL.log(msg);
        }

        @Override
        public void info(String msg) {
            this.infoL.log(msg);
        }

        @Override
        public void config(String msg) {
            this.debugL.log(msg);
        }

        @Override
        public void fine(String msg) {
            this.debugL.log(msg);
        }

        @Override
        public void finer(String msg) {
            this.debugL.log(msg);
        }

        @Override
        public void finest(String msg) {
            this.traceL.log(msg);
        }

        @Override
        public synchronized void setLevel(MLevel l) throws SecurityException {
            this.myLevel = l;
        }

        @Override
        public synchronized MLevel getLevel() {
            if (this.myLevel == null) {
                this.myLevel = this.guessMLevel();
            }
            return this.myLevel;
        }

        @Override
        public boolean isLoggable(MLevel l) {
            return this.levelLogger(l) != this.offL;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public void addHandler(Object h) throws SecurityException {
            throw new UnsupportedOperationException("Handlers not supported; the 'handler' " + h + " is not compatible with MLogger " + this);
        }

        @Override
        public void removeHandler(Object h) throws SecurityException {
            throw new UnsupportedOperationException("Handlers not supported; the 'handler' " + h + " is not compatible with MLogger " + this);
        }

        @Override
        public Object[] getHandlers() {
            return EMPTY_OBJ_ARRAY;
        }

        @Override
        public void setUseParentHandlers(boolean uph) {
            throw new UnsupportedOperationException("Handlers not supported.");
        }

        @Override
        public boolean getUseParentHandlers() {
            throw new UnsupportedOperationException("Handlers not supported.");
        }

        private class DebugLogger
        implements LevelLogger {
            private DebugLogger() {
            }

            @Override
            public void log(String msg) {
                Slf4jMLogger.this.logger.debug(msg);
            }

            @Override
            public void log(String format, Object param) {
                Slf4jMLogger.this.logger.debug(format, param);
            }

            @Override
            public void log(String format, Object[] params) {
                Slf4jMLogger.this.logger.debug(format, params);
            }

            @Override
            public void log(String msg, Throwable t) {
                Slf4jMLogger.this.logger.debug(msg, t);
            }
        }

        private class ErrorLogger
        implements LevelLogger {
            private ErrorLogger() {
            }

            @Override
            public void log(String msg) {
                Slf4jMLogger.this.logger.error(msg);
            }

            @Override
            public void log(String format, Object param) {
                Slf4jMLogger.this.logger.error(format, param);
            }

            @Override
            public void log(String format, Object[] params) {
                Slf4jMLogger.this.logger.error(format, params);
            }

            @Override
            public void log(String msg, Throwable t) {
                Slf4jMLogger.this.logger.error(msg, t);
            }
        }

        private class InfoLogger
        implements LevelLogger {
            private InfoLogger() {
            }

            @Override
            public void log(String msg) {
                Slf4jMLogger.this.logger.info(msg);
            }

            @Override
            public void log(String format, Object param) {
                Slf4jMLogger.this.logger.info(format, param);
            }

            @Override
            public void log(String format, Object[] params) {
                Slf4jMLogger.this.logger.info(format, params);
            }

            @Override
            public void log(String msg, Throwable t) {
                Slf4jMLogger.this.logger.info(msg, t);
            }
        }

        private static interface LevelLogger {
            public void log(String var1);

            public void log(String var1, Object var2);

            public void log(String var1, Object[] var2);

            public void log(String var1, Throwable var2);
        }

        private class OffLogger
        implements LevelLogger {
            private OffLogger() {
            }

            @Override
            public void log(String msg) {
            }

            @Override
            public void log(String format, Object param) {
            }

            @Override
            public void log(String format, Object[] params) {
            }

            @Override
            public void log(String msg, Throwable t) {
            }
        }

        private class TraceLogger
        implements LevelLogger {
            private TraceLogger() {
            }

            @Override
            public void log(String msg) {
                Slf4jMLogger.this.logger.trace(msg);
            }

            @Override
            public void log(String format, Object param) {
                Slf4jMLogger.this.logger.trace(format, param);
            }

            @Override
            public void log(String format, Object[] params) {
                Slf4jMLogger.this.logger.trace(format, params);
            }

            @Override
            public void log(String msg, Throwable t) {
                Slf4jMLogger.this.logger.trace(msg, t);
            }
        }

        private class WarnLogger
        implements LevelLogger {
            private WarnLogger() {
            }

            @Override
            public void log(String msg) {
                Slf4jMLogger.this.logger.warn(msg);
            }

            @Override
            public void log(String format, Object param) {
                Slf4jMLogger.this.logger.warn(format, param);
            }

            @Override
            public void log(String format, Object[] params) {
                Slf4jMLogger.this.logger.warn(format, params);
            }

            @Override
            public void log(String msg, Throwable t) {
                Slf4jMLogger.this.logger.warn(msg, t);
            }
        }
    }
}

