/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ReflectUtils {
    public static final Class[] PROXY_CTOR_ARGS = new Class[]{InvocationHandler.class};

    public static Constructor findProxyConstructor(ClassLoader proxyClassLoader, Class intfc) throws NoSuchMethodException {
        return ReflectUtils.findProxyConstructor(proxyClassLoader, new Class[]{intfc});
    }

    public static Constructor findProxyConstructor(ClassLoader proxyClassLoader, Class[] interfaces) throws NoSuchMethodException {
        Class<?> proxyCl = Proxy.getProxyClass(proxyClassLoader, interfaces);
        return proxyCl.getConstructor(PROXY_CTOR_ARGS);
    }

    public static boolean isPublic(Member m) {
        return (m.getModifiers() & 1) != 0;
    }

    public static boolean isPublic(Class cl) {
        return (cl.getModifiers() & 1) != 0;
    }

    public static Class findPublicParent(Class cl) {
        while ((cl = cl.getSuperclass()) != null && !ReflectUtils.isPublic(cl)) {
        }
        return cl;
    }

    public static Iterator traverseInterfaces(Class cl) {
        HashSet<Class> set = new HashSet<Class>();
        if (cl.isInterface()) {
            set.add(cl);
        }
        ReflectUtils.addParentInterfaces(set, cl);
        return set.iterator();
    }

    private static void addParentInterfaces(Set set, Class cl) {
        Class<?>[] intfcs = cl.getInterfaces();
        int i = 0;
        int len = intfcs.length;
        while (i < len) {
            set.add(intfcs[i]);
            ReflectUtils.addParentInterfaces(set, intfcs[i]);
            ++i;
        }
    }

    public static Method findInPublicScope(Method m) {
        if (!ReflectUtils.isPublic(m)) {
            return null;
        }
        Class origClass = m.getDeclaringClass();
        if (ReflectUtils.isPublic(origClass)) {
            return m;
        }
        Class cl = origClass;
        while ((cl = ReflectUtils.findPublicParent(cl)) != null) {
            try {
                return cl.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Iterator ii = ReflectUtils.traverseInterfaces(origClass);
        while (ii.hasNext()) {
            cl = (Class)ii.next();
            if (!ReflectUtils.isPublic(cl)) continue;
            try {
                return cl.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return null;
    }

    private ReflectUtils() {
    }
}

