/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.uid;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;

public final class UidUtils {
    static final MLogger logger = MLog.getLogger(UidUtils.class);
    public static final String VM_ID = UidUtils.generateVmId();
    private static long within_vm_seq_counter = 0L;

    private static String generateVmId() {
        FilterOutputStream dos = null;
        FilterInputStream dis = null;
        try {
            SecureRandom srand = new SecureRandom();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            try {
                dos.write(InetAddress.getLocalHost().getAddress());
            }
            catch (Exception e) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "Failed to get local InetAddress for VMID. This is unlikely to matter. At all. We'll add some extra randomness", e);
                }
                ((DataOutputStream)dos).write(srand.nextInt());
            }
            ((DataOutputStream)dos).writeLong(System.currentTimeMillis());
            ((DataOutputStream)dos).write(srand.nextInt());
            int remainder = baos.size() % 4;
            if (remainder > 0) {
                int pad = 4 - remainder;
                byte[] pad_bytes = new byte[pad];
                srand.nextBytes(pad_bytes);
                dos.write(pad_bytes);
            }
            StringBuffer sb = new StringBuffer(32);
            byte[] vmid_bytes = baos.toByteArray();
            dis = new DataInputStream(new ByteArrayInputStream(vmid_bytes));
            int i = 0;
            int num_ints = vmid_bytes.length / 4;
            while (i < num_ints) {
                int signed = ((DataInputStream)dis).readInt();
                long unsigned = (long)signed & 0xFFFFFFFFL;
                sb.append(Long.toString(unsigned, 36));
                ++i;
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Bizarro! IOException while reading/writing from ByteArray-based streams? We're skipping the VMID thing. It almost certainly doesn't matter, but please report the error.", e);
            }
            return "";
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound OutputStream.", e);
            }
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound IntputStream.", e);
            }
        }
    }

    private static synchronized long nextWithinVmSeq() {
        return ++within_vm_seq_counter;
    }

    public static String allocateWithinVmSequential() {
        return String.valueOf(VM_ID) + "#" + UidUtils.nextWithinVmSeq();
    }

    private UidUtils() {
    }
}

