/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public final class CollectionUtils {
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    static final Class[] EMPTY_ARG_CLASSES = new Class[0];
    static final Object[] EMPTY_ARGS = new Object[0];
    static final Class[] COMPARATOR_ARG_CLASSES = new Class[]{Comparator.class};
    static final Class[] COLLECTION_ARG_CLASSES = new Class[]{Collection.class};
    static final Class[] SORTED_SET_ARG_CLASSES = new Class[]{SortedSet.class};
    static final Class[] MAP_ARG_CLASSES = new Class[]{Map.class};
    static final Class[] SORTED_MAP_ARG_CLASSES = new Class[]{SortedMap.class};
    static final Class STD_UNMODIFIABLE_COLLECTION_CL;
    static final Class STD_UNMODIFIABLE_SET_CL;
    static final Class STD_UNMODIFIABLE_LIST_CL;
    static final Class STD_UNMODIFIABLE_RA_LIST_CL;
    static final Class STD_UNMODIFIABLE_SORTED_SET_CL;
    static final Class STD_UNMODIFIABLE_MAP_CL;
    static final Class STD_UNMODIFIABLE_SORTED_MAP_CL;
    static final Class STD_SYNCHRONIZED_COLLECTION_CL;
    static final Class STD_SYNCHRONIZED_SET_CL;
    static final Class STD_SYNCHRONIZED_LIST_CL;
    static final Class STD_SYNCHRONIZED_RA_LIST_CL;
    static final Class STD_SYNCHRONIZED_SORTED_SET_CL;
    static final Class STD_SYNCHRONIZED_MAP_CL;
    static final Class STD_SYNCHRONIZED_SORTED_MAP_CL;
    static final Set UNMODIFIABLE_WRAPPERS;
    static final Set SYNCHRONIZED_WRAPPERS;
    static final Set ALL_COLLECTIONS_WRAPPERS;

    static {
        HashSet hs = new HashSet();
        TreeSet ts = new TreeSet();
        LinkedList ll = new LinkedList();
        ArrayList al = new ArrayList();
        HashMap hm = new HashMap();
        TreeMap tm = new TreeMap();
        HashSet tmp0 = new HashSet();
        HashSet tmp1 = new HashSet();
        STD_UNMODIFIABLE_COLLECTION_CL = Collections.unmodifiableCollection(al).getClass();
        tmp0.add(STD_UNMODIFIABLE_COLLECTION_CL);
        STD_UNMODIFIABLE_SET_CL = Collections.unmodifiableSet(hs).getClass();
        tmp0.add(STD_UNMODIFIABLE_SET_CL);
        STD_UNMODIFIABLE_LIST_CL = Collections.unmodifiableList(ll).getClass();
        tmp0.add(STD_UNMODIFIABLE_LIST_CL);
        STD_UNMODIFIABLE_RA_LIST_CL = Collections.unmodifiableList(al).getClass();
        tmp0.add(STD_UNMODIFIABLE_RA_LIST_CL);
        STD_UNMODIFIABLE_SORTED_SET_CL = Collections.unmodifiableSortedSet(ts).getClass();
        tmp0.add(STD_UNMODIFIABLE_SORTED_SET_CL);
        STD_UNMODIFIABLE_MAP_CL = Collections.unmodifiableMap(hm).getClass();
        tmp0.add(STD_UNMODIFIABLE_MAP_CL);
        STD_UNMODIFIABLE_SORTED_MAP_CL = Collections.unmodifiableSortedMap(tm).getClass();
        tmp0.add(STD_UNMODIFIABLE_SORTED_MAP_CL);
        STD_SYNCHRONIZED_COLLECTION_CL = Collections.synchronizedCollection(al).getClass();
        tmp1.add(STD_SYNCHRONIZED_COLLECTION_CL);
        STD_SYNCHRONIZED_SET_CL = Collections.synchronizedSet(hs).getClass();
        tmp1.add(STD_SYNCHRONIZED_SET_CL);
        STD_SYNCHRONIZED_LIST_CL = Collections.synchronizedList(ll).getClass();
        tmp1.add(STD_SYNCHRONIZED_LIST_CL);
        STD_SYNCHRONIZED_RA_LIST_CL = Collections.synchronizedList(al).getClass();
        tmp1.add(STD_SYNCHRONIZED_RA_LIST_CL);
        STD_SYNCHRONIZED_SORTED_SET_CL = Collections.synchronizedSortedSet(ts).getClass();
        tmp1.add(STD_SYNCHRONIZED_SORTED_SET_CL);
        STD_SYNCHRONIZED_MAP_CL = Collections.synchronizedMap(hm).getClass();
        tmp1.add(STD_SYNCHRONIZED_MAP_CL);
        STD_SYNCHRONIZED_SORTED_MAP_CL = Collections.synchronizedMap(tm).getClass();
        tmp1.add(STD_SYNCHRONIZED_SORTED_MAP_CL);
        UNMODIFIABLE_WRAPPERS = Collections.unmodifiableSet(tmp0);
        SYNCHRONIZED_WRAPPERS = Collections.unmodifiableSet(tmp1);
        HashSet tmp2 = new HashSet(tmp0);
        tmp2.addAll(tmp1);
        ALL_COLLECTIONS_WRAPPERS = Collections.unmodifiableSet(tmp2);
    }

    public static boolean isCollectionsWrapper(Class cl) {
        return ALL_COLLECTIONS_WRAPPERS.contains(cl);
    }

    public static boolean isCollectionsWrapper(Collection c) {
        return CollectionUtils.isCollectionsWrapper(c.getClass());
    }

    public static boolean isCollectionsWrapper(Map m) {
        return CollectionUtils.isCollectionsWrapper(m.getClass());
    }

    public static boolean isSynchronizedWrapper(Class cl) {
        return SYNCHRONIZED_WRAPPERS.contains(cl);
    }

    public static boolean isSynchronizedWrapper(Collection c) {
        return CollectionUtils.isSynchronizedWrapper(c.getClass());
    }

    public static boolean isSynchronizedWrapper(Map m) {
        return CollectionUtils.isSynchronizedWrapper(m.getClass());
    }

    public static boolean isUnmodifiableWrapper(Class cl) {
        return UNMODIFIABLE_WRAPPERS.contains(cl);
    }

    public static boolean isUnmodifiableWrapper(Collection c) {
        return CollectionUtils.isUnmodifiableWrapper(c.getClass());
    }

    public static boolean isUnmodifiableWrapper(Map m) {
        return CollectionUtils.isUnmodifiableWrapper(m.getClass());
    }

    public static Collection narrowUnmodifiableCollection(Collection c) {
        if (c instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)c);
        }
        if (c instanceof Set) {
            return Collections.unmodifiableSet((Set)c);
        }
        if (c instanceof List) {
            return Collections.unmodifiableList((List)c);
        }
        return Collections.unmodifiableCollection(c);
    }

    public static Collection narrowSynchronizedCollection(Collection c) {
        if (c instanceof SortedSet) {
            return Collections.synchronizedSortedSet((SortedSet)c);
        }
        if (c instanceof Set) {
            return Collections.synchronizedSet((Set)c);
        }
        if (c instanceof List) {
            return Collections.synchronizedList((List)c);
        }
        return Collections.synchronizedCollection(c);
    }

    public static Map narrowUnmodifiableMap(Map m) {
        if (m instanceof SortedMap) {
            return Collections.unmodifiableSortedMap((SortedMap)m);
        }
        return Collections.unmodifiableMap(m);
    }

    public static Map narrowSynchronizedMap(Map m) {
        if (m instanceof SortedMap) {
            return Collections.synchronizedSortedMap((SortedMap)m);
        }
        return Collections.synchronizedMap(m);
    }

    public static Collection attemptClone(Collection c) throws NoSuchMethodException {
        Constructor<?> ctor;
        if (c instanceof Vector) {
            return (Collection)((Vector)c).clone();
        }
        if (c instanceof ArrayList) {
            return (Collection)((ArrayList)c).clone();
        }
        if (c instanceof LinkedList) {
            return (Collection)((LinkedList)c).clone();
        }
        if (c instanceof HashSet) {
            return (Collection)((HashSet)c).clone();
        }
        if (c instanceof TreeSet) {
            return (Collection)((TreeSet)c).clone();
        }
        Collection out = null;
        Class<?> colClass = c.getClass();
        try {
            Method m = colClass.getMethod("clone", EMPTY_ARG_CLASSES);
            out = (Collection)m.invoke((Object)c, EMPTY_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (out == null) {
            try {
                ctor = colClass.getConstructor(c instanceof SortedSet ? SORTED_SET_ARG_CLASSES : COLLECTION_ARG_CLASSES);
                out = (Collection)ctor.newInstance(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (out == null) {
            try {
                ctor = colClass.getConstructor(colClass);
                out = (Collection)ctor.newInstance(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (out == null) {
            throw new NoSuchMethodException("No accessible clone() method or reasonable copy constructor could be called on Collection " + c);
        }
        return out;
    }

    public static Map attemptClone(Map m) throws NoSuchMethodException {
        Constructor<?> ctor;
        if (m instanceof Properties) {
            return (Map)((Properties)m).clone();
        }
        if (m instanceof Hashtable) {
            return (Map)((Hashtable)m).clone();
        }
        if (m instanceof HashMap) {
            return (Map)((HashMap)m).clone();
        }
        if (m instanceof TreeMap) {
            return (Map)((TreeMap)m).clone();
        }
        Map out = null;
        Class<?> mapClass = m.getClass();
        try {
            Method meth = mapClass.getMethod("clone", EMPTY_ARG_CLASSES);
            out = (Map)meth.invoke((Object)m, EMPTY_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (out == null) {
            try {
                ctor = mapClass.getConstructor(m instanceof SortedMap ? SORTED_MAP_ARG_CLASSES : MAP_ARG_CLASSES);
                out = (Map)ctor.newInstance(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (out == null) {
            try {
                ctor = mapClass.getConstructor(mapClass);
                out = (Map)ctor.newInstance(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (out == null) {
            throw new NoSuchMethodException("No accessible clone() method or reasonable copy constructor could be called on Map " + m);
        }
        return out;
    }

    public static void add(Collection c, Object o) {
        c.add(o);
    }

    public static void remove(Collection c, Object o) {
        c.remove(o);
    }

    public static int size(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length;
        }
        if (o instanceof boolean[]) {
            return ((boolean[])o).length;
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length;
        }
        if (o instanceof char[]) {
            return ((char[])o).length;
        }
        if (o instanceof short[]) {
            return ((short[])o).length;
        }
        if (o instanceof int[]) {
            return ((int[])o).length;
        }
        if (o instanceof long[]) {
            return ((long[])o).length;
        }
        if (o instanceof float[]) {
            return ((float[])o).length;
        }
        if (o instanceof double[]) {
            return ((double[])o).length;
        }
        throw new IllegalArgumentException(o + " must be a Collection, Map, or array!");
    }

    private CollectionUtils() {
    }
}

