/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.concurrent;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public final class BoundedExecutorService
extends AbstractExecutorService {
    static final MLogger logger = MLog.getLogger(BoundedExecutorService.class);
    final ExecutorService inner;
    final int blockBound;
    final int restartBeneath;
    State state;
    int permits;
    Map<Thread, Runnable> waiters = new HashMap<Thread, Runnable>();

    public BoundedExecutorService(ExecutorService inner, int blockBound, int restartBeneath) {
        if (blockBound <= 0 || restartBeneath <= 0) {
            throw new IllegalArgumentException("blockBound and restartBeneath must both be greater than zero!");
        }
        if (restartBeneath > blockBound) {
            throw new IllegalArgumentException("restartBeneath must be less than or equal to blockBound!");
        }
        this.inner = inner;
        this.blockBound = blockBound;
        this.restartBeneath = restartBeneath;
        this.state = State.ACCEPTING;
        this.permits = 0;
    }

    public BoundedExecutorService(ExecutorService inner, int blockBound) {
        this(inner, blockBound, blockBound);
    }

    public synchronized State getState() {
        return this.state;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.state == State.SHUTDOWN || this.state == State.SHUTDOWN_NOW;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.isShutdown() && this.permits == 0;
    }

    @Override
    public synchronized void shutdown() {
        this.inner.shutdown();
        this.updateState(State.SHUTDOWN);
        this.notifyAll();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.updateState(State.SHUTDOWN_NOW);
        List<Runnable> innerLeftovers = this.inner.shutdownNow();
        Collection<Runnable> ourLeftovers = this.waiters.values();
        ArrayList<Runnable> out = new ArrayList<Runnable>(innerLeftovers.size() + ourLeftovers.size());
        out.addAll(innerLeftovers);
        out.addAll(ourLeftovers);
        Iterator<Thread> ii = this.waiters.keySet().iterator();
        while (ii.hasNext()) {
            ii.next().interrupt();
        }
        this.waiters.clear();
        return Collections.unmodifiableList(out);
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.currentTimeMillis();
        long timeoutMillis = start + TimeUnit.MILLISECONDS.convert(timeout, unit);
        boolean innerTerminated = this.inner.awaitTermination(timeout, unit);
        if (innerTerminated) {
            long now = System.currentTimeMillis();
            while (!this.isTerminated()) {
                if (now > timeoutMillis) {
                    return false;
                }
                this.wait(timeoutMillis - now);
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(Runnable runnable) {
        this.inner.execute(this.newTaskFor(runnable, (V)null));
    }

    protected <V> RunnableFuture<V> newTaskFor(Callable<V> callable) {
        ReleasingFutureTask<V> out = new ReleasingFutureTask<V>(callable);
        this.acquirePermit(out);
        return out;
    }

    protected <V> RunnableFuture<V> newTaskFor(Runnable runnable, V result) {
        ReleasingFutureTask<V> out = new ReleasingFutureTask<V>(runnable, result);
        this.acquirePermit(out);
        return out;
    }

    private boolean shouldWait() {
        switch (this.state) {
            case SHUTDOWN: 
            case SHUTDOWN_NOW: {
                return this.permits == this.blockBound;
            }
            case ACCEPTING: {
                return false;
            }
            case SATURATED: 
            case UNWINDING: {
                return true;
            }
        }
        throw new AssertionError((Object)"This should be dead code.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void acquirePermit(Runnable task) {
        try {
            switch (this.state) {
                case SHUTDOWN: 
                case SHUTDOWN_NOW: {
                    throw new RejectedExecutionException(this + " has been shut down. [state=" + (Object)((Object)this.state) + "]");
                }
                case ACCEPTING: 
                case SATURATED: 
                case UNWINDING: {
                    while (this.shouldWait()) {
                        try {
                            this.waiters.put(Thread.currentThread(), task);
                            this.wait();
                        }
                        finally {
                            this.waiters.remove(Thread.currentThread());
                        }
                    }
                    if (this.state == State.SHUTDOWN_NOW) return;
                    ++this.permits;
                    if (this.permits != this.blockBound) return;
                    this.updateState(State.SATURATED);
                }
                default: {
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(this + " has been forcibly shut down. [state=" + (Object)((Object)this.state) + "]", e);
        }
    }

    private synchronized void releasePermit() {
        --this.permits;
        if (this.permits < this.restartBeneath) {
            this.updateState(State.ACCEPTING);
        } else if (this.state == State.SATURATED && this.permits < this.blockBound) {
            this.updateState(State.UNWINDING);
        }
    }

    private void updateState(State newState) {
        switch (this.state) {
            case ACCEPTING: 
            case SATURATED: 
            case UNWINDING: {
                if (this.state == newState) break;
                this.doUpdateState(newState);
                break;
            }
            case SHUTDOWN: {
                if (newState != State.SHUTDOWN_NOW) break;
                this.doUpdateState(newState);
            }
        }
    }

    private void doUpdateState(State newState) {
        if (logger.isLoggable(MLevel.FINE)) {
            logger.log(MLevel.FINE, "State transition " + (Object)((Object)this.state) + " => " + (Object)((Object)newState) + "; blockBound=" + this.blockBound + "; restartBeneath=" + this.restartBeneath + "; permits=" + this.permits);
        }
        this.state = newState;
        if (this.state == State.SHUTDOWN_NOW) {
            this.permits = 0;
        }
        this.notifyAll();
    }

    class ReleasingFutureTask<V>
    extends FutureTask<V> {
        ReleasingFutureTask(Callable<V> callable) {
            super(callable);
        }

        ReleasingFutureTask(Runnable runnable, V result) {
            super(runnable, result);
        }

        @Override
        protected void done() {
            BoundedExecutorService.this.releasePermit();
        }
    }

    static enum State {
        ACCEPTING,
        SATURATED,
        UNWINDING,
        SHUTDOWN,
        SHUTDOWN_NOW;

    }
}

