/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.ReaderUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import com.mchange.v3.filecache.URLFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum URLFetchers implements URLFetcher
{
    DEFAULT{

        @Override
        public InputStream openStream(URL u, MLogger logger) throws IOException {
            return u.openStream();
        }
    }
    ,
    BUFFERED_WGET{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public InputStream openStream(URL u, MLogger logger) throws IOException {
            Throwable throwable3222;
            Process p;
            block17: {
                BufferedReader errReader;
                block18: {
                    ByteArrayInputStream byteArrayInputStream;
                    p = new ProcessBuilder("wget", "-O", "-", u.toString()).start();
                    BufferedInputStream is = null;
                    try {
                        is = new BufferedInputStream(p.getInputStream(), 0x100000);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
                        int b = ((InputStream)is).read();
                        while (true) {
                            if (b < 0) {
                                byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                                break;
                            }
                            baos.write(b);
                            b = ((InputStream)is).read();
                        }
                    }
                    catch (Throwable throwable3222) {
                        InputStreamUtils.attemptClose(is);
                        if (!logger.isLoggable(MLevel.FINER)) break block17;
                        errReader = null;
                        try {
                            errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                            StringWriter writer = new StringWriter(0x100000);
                            int c = ((Reader)errReader).read();
                            while (true) {
                                if (c < 0) {
                                    logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                                    break block18;
                                }
                                writer.write(c);
                                c = ((Reader)errReader).read();
                            }
                        }
                        catch (Throwable throwable4) {
                            ReaderUtils.attemptClose(errReader);
                            throw throwable4;
                        }
                    }
                    InputStreamUtils.attemptClose(is);
                    if (logger.isLoggable(MLevel.FINER)) {
                        BufferedReader errReader2 = null;
                        try {
                            errReader2 = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                            StringWriter writer = new StringWriter(0x100000);
                            int c = ((Reader)errReader2).read();
                            while (c >= 0) {
                                writer.write(c);
                                c = ((Reader)errReader2).read();
                            }
                            logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                        }
                        catch (Throwable throwable2) {
                            ReaderUtils.attemptClose(errReader2);
                            throw throwable2;
                        }
                        ReaderUtils.attemptClose(errReader2);
                    }
                    try {
                        int check = p.waitFor();
                        if (check == 0) return byteArrayInputStream;
                        throw new IOException("wget process terminated abnormally [return code: " + check + "]");
                    }
                    catch (InterruptedException e) {
                        if (!logger.isLoggable(MLevel.FINER)) throw new IOException("Interrupted while waiting for wget to complete: " + e);
                        logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                        throw new IOException("Interrupted while waiting for wget to complete: " + e);
                    }
                }
                ReaderUtils.attemptClose(errReader);
            }
            try {
                int check = p.waitFor();
                if (check == 0) throw throwable3222;
                throw new IOException("wget process terminated abnormally [return code: " + check + "]");
            }
            catch (InterruptedException e) {
                if (!logger.isLoggable(MLevel.FINER)) throw new IOException("Interrupted while waiting for wget to complete: " + e);
                logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                throw new IOException("Interrupted while waiting for wget to complete: " + e);
            }
        }
    };

}

