/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HoconMultiPropertiesConfig
extends MultiPropertiesConfig {
    String quasiResourcePath;
    Properties props;
    List<DelayedLogItem> delayedLogItems = new LinkedList<DelayedLogItem>();
    Map<String, Properties> propsByPrefix = new HashMap<String, Properties>();

    public HoconMultiPropertiesConfig(String quasiResourcePath, Config config) {
        this.quasiResourcePath = quasiResourcePath;
        this.props = this.propsForConfig(config);
    }

    private Properties propsForConfig(Config config) {
        Properties out = new Properties();
        for (Map.Entry entry : config.entrySet()) {
            try {
                out.put(entry.getKey(), HoconMultiPropertiesConfig.asSimpleString((ConfigValue)entry.getValue()));
            }
            catch (IllegalArgumentException e) {
                this.delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.FINE, "For property '" + (String)entry.getKey() + "', " + e.getMessage()));
            }
        }
        return out;
    }

    private static String asSimpleString(ConfigValue value) throws IllegalArgumentException {
        ConfigValueType type = value.valueType();
        switch (type) {
            case NUMBER: 
            case BOOLEAN: 
            case STRING: {
                return String.valueOf(value.unwrapped());
            }
            case LIST: {
                ConfigList l = (ConfigList)value;
                for (ConfigValue cv : l) {
                    if (HoconMultiPropertiesConfig.isSimple(cv)) continue;
                    throw new IllegalArgumentException("value is a complex list, could not be rendered as a simple property: " + value);
                }
                StringBuilder sb = new StringBuilder();
                int i = 0;
                int len = l.size();
                while (i < len) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(HoconMultiPropertiesConfig.asSimpleString((ConfigValue)l.get(i)));
                    ++i;
                }
                return sb.toString();
            }
            case OBJECT: {
                throw new IllegalArgumentException("value is a ConfigValue object rather than an atom or list of atoms: " + value);
            }
            case NULL: {
                throw new IllegalArgumentException("value is a null; will be excluded from the MultiPropertiesConfig: " + value);
            }
        }
        throw new IllegalArgumentException("value of an unexpected type: (value->" + value + ", type->" + type + ")");
    }

    private static boolean isSimple(ConfigValue value) {
        ConfigValueType type = value.valueType();
        switch (type) {
            case NUMBER: 
            case BOOLEAN: 
            case STRING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getPropertiesResourcePaths() {
        return new String[]{this.quasiResourcePath};
    }

    @Override
    public Properties getPropertiesByResourcePath(String path) {
        if (path.equals(this.quasiResourcePath)) {
            Properties out = new Properties();
            out.putAll((Map<?, ?>)this.props);
            return out;
        }
        return null;
    }

    @Override
    public synchronized Properties getPropertiesByPrefix(String pfx) {
        Properties outish = this.propsByPrefix.get(pfx);
        if (outish == null) {
            outish = new Properties();
            if ("".equals(pfx)) {
                outish.putAll((Map<?, ?>)this.props);
            } else {
                String dottedPfx = String.valueOf(pfx) + '.';
                for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith(dottedPfx)) continue;
                    outish.put(key, entry.getValue());
                }
            }
            this.propsByPrefix.put(pfx, outish);
        }
        return outish;
    }

    @Override
    public String getProperty(String key) {
        return (String)this.props.get(key);
    }

    @Override
    public List getDelayedLogItems() {
        return this.delayedLogItems;
    }
}

