/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class HoconUtils {
    private static final String APPLICATION = "application";

    public static PropertiesConversion configToProperties(Config config) {
        Set entries = config.entrySet();
        Properties properties = new Properties();
        HashSet<String> unrenderable = new HashSet<String>();
        for (Map.Entry entry : entries) {
            String path = (String)entry.getKey();
            String value = null;
            try {
                value = config.getString(path);
            }
            catch (ConfigException.WrongType wrongType) {
                unrenderable.add(path);
            }
            if (value == null) continue;
            properties.setProperty(path, value);
        }
        PropertiesConversion out = new PropertiesConversion();
        out.properties = properties;
        out.unrenderable = unrenderable;
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config applicationOrStandardSubstitute(ClassLoader cl) throws SubstituteNotAvailableException {
        String resourcePath = APPLICATION;
        Config out = null;
        String check = System.getProperty("config.resource");
        if (check != null) {
            resourcePath = check;
        } else {
            check = System.getProperty("config.file");
            if (check != null) {
                File f = new File(check);
                if (!f.exists()) throw new SubstituteNotAvailableException(String.format("Specified config.file '%s' (specified as a System property) does not exist.", f.getAbsolutePath()));
                if (!f.canRead()) throw new SubstituteNotAvailableException(String.format("config.file '%s' (specified as a System property) is not readable.", f.getAbsolutePath()));
                out = ConfigFactory.parseFile((File)f);
            } else {
                check = System.getProperty("config.url");
                if (check != null) {
                    try {
                        out = ConfigFactory.parseURL((URL)new URL(check));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SubstituteNotAvailableException(String.format("Specified config.url '%s' (specified as a System property) could not be parsed.", check));
                    }
                }
            }
        }
        if (out != null) return out;
        return ConfigFactory.parseResourcesAnySyntax((ClassLoader)cl, (String)resourcePath);
    }

    public static ConfigWithFallbackMessage applicationOrStandardSubstituteFallbackWithMessage(ClassLoader cl) throws SubstituteNotAvailableException {
        try {
            return new ConfigWithFallbackMessage(HoconUtils.applicationOrStandardSubstitute(cl), null);
        }
        catch (SubstituteNotAvailableException e) {
            return new ConfigWithFallbackMessage(ConfigFactory.parseResourcesAnySyntax((ClassLoader)cl, (String)APPLICATION), String.valueOf(e.getMessage()) + " Falling back to standard application.(conf|json|properties).");
        }
    }

    public static WarnedConfig customFileOrSpecifiedSourceWins(File customFile) {
        boolean configuredLocation;
        ArrayList<String> warnings = new ArrayList<String>();
        boolean fileExists = customFile.exists();
        Properties sysprops = System.getProperties();
        boolean bl = configuredLocation = sysprops.containsKey("config.resource") || sysprops.containsKey("config.file") || sysprops.containsKey("config.url");
        if (configuredLocation && fileExists) {
            warnings.add(HoconUtils.createSpecifiedSourceWarning(customFile, sysprops));
            return new WarnedConfig(ConfigFactory.load(), warnings);
        }
        if (!fileExists) {
            return new WarnedConfig(ConfigFactory.load(), warnings);
        }
        Config out = ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)ConfigFactory.parseFile((File)customFile).withFallback((ConfigMergeable)ConfigFactory.defaultApplication().withFallback((ConfigMergeable)ConfigFactory.defaultReference())));
        return new WarnedConfig(out, warnings);
    }

    private static String createSpecifiedSourceWarning(File customFile, Properties sysprops) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append("Config file ");
        sb.append(customFile.getAbsolutePath());
        sb.append(" will be ignored because a location has been explicitly set via System.properties. [");
        if (sysprops.containsKey("config.resource")) {
            sb.append("config.resource=" + sysprops.getProperty("config.resource"));
            first = false;
        }
        if (sysprops.containsKey("config.file")) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("config.file=" + sysprops.getProperty("config.file"));
            first = false;
        }
        if (sysprops.containsKey("config.url")) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("config.url=" + sysprops.getProperty("config.url"));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    private HoconUtils() {
    }

    public static class ConfigWithFallbackMessage {
        private Config _config;
        private String _message;

        public Config config() {
            return this._config;
        }

        public String message() {
            return this._message;
        }

        private ConfigWithFallbackMessage(Config config, String message) {
            this._config = config;
            this._message = message;
        }
    }

    public static class PropertiesConversion {
        Properties properties;
        Set<String> unrenderable;
    }

    public static class SubstituteNotAvailableException
    extends Exception {
        SubstituteNotAvailableException(String msg) {
            super(msg);
        }
    }

    public static class WarnedConfig {
        public Config config;
        public List<String> warnings;

        WarnedConfig(Config config, List<String> warnings) {
            this.config = config;
            this.warnings = warnings;
        }
    }
}

