/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client;

import de.elpro.java.common.utils.JavaSystemUtils;
import java.net.InetAddress;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class ConnectionDefinition {
    public static final ConnectionDefinition INSTANCE = new ConnectionDefinition();
    private static String PWD_SALT;
    private static final String NODE = "eos-client";
    private final IEclipsePreferences node;
    public static final int DEFAULT_PORT = 443;
    private StringProperty protocol = new SimpleStringProperty("https://");
    private StringProperty hostName = new SimpleStringProperty();
    private IntegerProperty port = new SimpleIntegerProperty();
    private StringProperty instance = new SimpleStringProperty();
    private StringProperty login = new SimpleStringProperty();
    private BooleanProperty savePassword = new SimpleBooleanProperty();
    private StringProperty password = new SimpleStringProperty();

    private ConnectionDefinition() {
        this.node = InstanceScope.INSTANCE.getNode(NODE);
        this.load();
    }

    public String getProtocol() {
        return (String)this.protocol.get();
    }

    public Property<String> protocolProperty() {
        return this.protocol;
    }

    public String getHostName() {
        return (String)this.hostName.get();
    }

    public Property<String> hostNameProperty() {
        return this.hostName;
    }

    public int getPort() {
        return this.port.get();
    }

    public Property<Number> portProperty() {
        return this.port;
    }

    public String getInstance() {
        return (String)this.instance.get();
    }

    public Property<String> instanceProperty() {
        return this.instance;
    }

    public String getLogin() {
        return (String)this.login.get();
    }

    public void setLogin(String login) {
        this.login.set((Object)login);
    }

    public Property<String> loginProperty() {
        return this.login;
    }

    public boolean getSavePassword() {
        return this.savePassword.get();
    }

    public Property<Boolean> savePasswordProperty() {
        return this.savePassword;
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public void setPassword(String password) {
        this.password.set((Object)password);
    }

    public Property<String> passwordProperty() {
        return this.password;
    }

    public String getConnectionUrl() {
        String url = String.format("%s%s:%d/%s", this.protocol.get(), this.hostName.get(), this.port.get(), this.instance.get());
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        return String.valueOf(url) + "rest/";
    }

    private static String getPWD_SALT() {
        if (PWD_SALT == null) {
            String hostName = "";
            String login = System.getProperty("user.name");
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {}
            PWD_SALT = String.valueOf(hostName) + ":" + login + "/";
        }
        return PWD_SALT;
    }

    private static String encryptPassword(String decryptedPassword) {
        if (decryptedPassword == null) {
            return null;
        }
        try {
            char[] passwd = "mdibkl349cklZ02aXSx2_".toCharArray();
            int i = 0;
            while (i < passwd.length) {
                passwd[i] = (char)(passwd[i] + i % 2);
                ++i;
            }
            String PWD = String.copyValueOf(passwd);
            StandardPBEStringEncryptor textEncryptor = new StandardPBEStringEncryptor();
            textEncryptor.setPassword(PWD);
            String encryptedResult = textEncryptor.encrypt(String.valueOf(ConnectionDefinition.getPWD_SALT()) + decryptedPassword);
            return encryptedResult;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String decryptPassword(String encryptedPassword) {
        String decryptedResult;
        block5: {
            if (encryptedPassword == null) {
                return null;
            }
            try {
                char[] passwd = "mdibkl349cklZ02aXSx2_".toCharArray();
                int i = 0;
                while (i < passwd.length) {
                    passwd[i] = (char)(passwd[i] + i % 2);
                    ++i;
                }
                String PWD = String.copyValueOf(passwd);
                StandardPBEStringEncryptor textEncryptor = new StandardPBEStringEncryptor();
                textEncryptor.setPassword(PWD);
                decryptedResult = textEncryptor.decrypt(encryptedPassword);
                if (decryptedResult.startsWith(ConnectionDefinition.getPWD_SALT())) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return decryptedResult.substring(ConnectionDefinition.getPWD_SALT().length(), decryptedResult.length());
    }

    private void load() {
        String userName;
        String defaultHost = System.getProperty("eos.login.host", "localhost");
        String defaultPort = System.getProperty("eos.login.port", "443");
        String defaultUser = System.getProperty("eos.login.user");
        int defaultPortNr = 443;
        try {
            defaultPortNr = Integer.parseInt(defaultPort);
            if (defaultPortNr < 0) {
                defaultPortNr = 443;
            }
        }
        catch (Exception exception) {}
        if (defaultUser != null && !defaultUser.isBlank() && defaultUser.contains("{$user}") && (userName = JavaSystemUtils.getUserName()) != null && !userName.isBlank()) {
            defaultUser = defaultUser.replace("{$user}", userName);
        }
        this.protocol.set((Object)this.node.get("protocol", "https://"));
        this.hostName.set((Object)this.node.get("host-name", defaultHost));
        this.port.set(this.node.getInt("port", defaultPortNr));
        this.instance.set((Object)this.node.get("instance", ""));
        this.login.set((Object)this.node.get("login", defaultUser));
        this.savePassword.set(this.node.getBoolean("save-password", false));
        this.password.set((Object)ConnectionDefinition.decryptPassword(this.node.get("password", null)));
    }

    public void persistServerCredentials() {
        this.node.put("protokol", (String)this.protocol.get());
        this.node.put("host-name", (String)this.hostName.get());
        this.node.putInt("port", this.port.get());
        try {
            this.node.flush();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void persist() {
        this.node.put("protokol", (String)this.protocol.get());
        this.node.put("host-name", (String)this.hostName.get());
        this.node.putInt("port", this.port.get());
        this.node.put("instance", (String)this.instance.get());
        this.node.put("login", (String)this.login.get());
        this.node.putBoolean("save-password", this.savePassword.get());
        if (this.savePassword.get()) {
            String encryptedPassword = ConnectionDefinition.encryptPassword((String)this.password.get());
            if (encryptedPassword != null) {
                this.node.put("password", ConnectionDefinition.encryptPassword((String)this.password.get()));
            } else {
                this.node.remove("password");
            }
        } else {
            this.node.remove("password");
        }
        try {
            this.node.flush();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

