/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.auth;

import de.elpro.ewms.core.auth.LoginResponse;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public class UserDAO {
    private static final String PREFIX = "auth/user";

    public static LoginResponse requestLoginToken(String domain, String login) {
        String path = String.format("%s/request_login_token/domain=%s&login=%s", PREFIX, domain != null ? domain : "", login);
        return (LoginResponse)Client.getWebTarget().path(path).request().get(LoginResponse.class);
    }

    public static LoginResponse login(String domain, String login, boolean encodedPassphrase, String passphrase) {
        return (LoginResponse)Client.getWebTarget().path(String.format("%s/login/domain=%s&login=%s&passphrase_encoded=%s&passphrase=%s", PREFIX, domain != null ? domain : "", login, Boolean.toString(encodedPassphrase), passphrase)).request().get(LoginResponse.class);
    }

    public static User get() {
        return (User)Client.getWebTarget().path(String.format("%s/get", PREFIX)).request().get(User.class);
    }

    public static User get(Transaction trx, int id) {
        return (User)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(User.class);
    }

    public static User[] get(Transaction trx, int[] ids) {
        return (User[])Client.getWebTarget().path(String.format("%s/get/trx=%s", PREFIX, trx)).request().post(Entity.json((Object)ids)).readEntity(User[].class);
    }

    public static Map<Integer, User> getAsMap(Transaction trx, int[] ids) {
        User[] users = UserDAO.get(trx, ids);
        HashMap<Integer, User> map = new HashMap<Integer, User>();
        User[] userArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            User user = userArray[n2];
            map.put(user.getId(), user);
            ++n2;
        }
        return map;
    }

    public static User[] getAll(Transaction trx) {
        return (User[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(User[].class);
    }

    public static void changePassword(Transaction trx, String domain, String login, String oldEncryptedPassword, String newEncryptedPassword) throws DAOOperationException {
        Response response;
        OperationResult result;
        FormDataMultiPart fdmp = new FormDataMultiPart();
        if (oldEncryptedPassword != null && !oldEncryptedPassword.isEmpty()) {
            fdmp.field("old_enc_passwd", oldEncryptedPassword);
        }
        if (newEncryptedPassword != null && !newEncryptedPassword.isEmpty()) {
            fdmp.field("new_enc_passwd", newEncryptedPassword);
        }
        if ((result = (OperationResult)(response = Client.getWebTarget().path(String.format("%s/change_passwd/trx=%s&domain=%s&login=%s", PREFIX, trx, domain != null ? domain : "", login)).request().post(Entity.entity((Object)fdmp, (MediaType)fdmp.getMediaType()))).readEntity(OperationResult.class)).getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static int register(User user, String encryptedPassword) throws DAOOperationException {
        String url = String.format("%s/register/enc_passwd=%s", PREFIX, encryptedPassword);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)user));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static int create(Transaction trx, User user, String encryptedPassword) throws DAOOperationException {
        String url = String.format("%s/create/trx=%s&enc_passwd=%s", PREFIX, trx, encryptedPassword);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)user));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static int update(Transaction trx, User user) throws DAOOperationException {
        String url = String.format("%s/update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)user));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

