/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class Characteristic2DInstanceDAO {
    public static final String PREFIX = "characteristic/2d_instance";

    public static Characteristic2DInstance get(Transaction trx, int id) {
        return (Characteristic2DInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Characteristic2DInstance.class);
    }

    public static Characteristic2DInstance get(Transaction trx, Characteristic2D characteristic2d, StructureObject structureObject) {
        return (Characteristic2DInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&c2d_id=%d&object_id=%d", PREFIX, trx, characteristic2d.getId(), structureObject.getId())).request().get(Characteristic2DInstance.class);
    }

    public static Characteristic2DInstance[] getAll(Transaction trx, Characteristic2D characteristic2d) {
        return (Characteristic2DInstance[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&c2d_id=%d", PREFIX, trx, characteristic2d.getId())).request().get(Characteristic2DInstance[].class);
    }

    public static int saveOrUpdate(Transaction trx, Characteristic2DInstance c2di) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)c2di));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void applyCurveValuesChanges(Transaction trx, Characteristic2DInstance instance, Characteristic2DFunctionChange[] changes) throws DAOOperationException {
        String url = String.format("%s/apply_curve_changes/trx=%s&id=%d", PREFIX, trx, instance.getId());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)changes));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

