/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.PhysicalUnit;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class Characteristic3DDAO {
    public static final String PREFIX = "characteristic/3d";

    public static Characteristic3D get(Transaction trx, int id) {
        return (Characteristic3D)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Characteristic3D.class);
    }

    public static Characteristic3D[] getAll(Transaction trx) {
        return (Characteristic3D[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Characteristic3D[].class);
    }

    public static Characteristic3D[] getByClass(Transaction trx, StructureClass structureClass) {
        return (Characteristic3D[])Client.getWebTarget().path(String.format("%s/get_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Characteristic3D[].class);
    }

    public static Characteristic3D[] getAvailable(Transaction trx, StructureClass rootClass, PhysicalUnit inputXPU, PhysicalUnit inputYPU, PhysicalUnit outputZPU, PhysicalUnit outputWPU) {
        String text = String.format("%s/get_available/trx=%s&root_class_id=%d&input_x_pu=%s&input_y_pu=%s&output_z_pu=%s&output_w_pu=%s", PREFIX, trx, rootClass.getId(), inputXPU.getKey(), inputYPU.getKey(), outputZPU.getKey(), outputWPU != null ? outputWPU.getKey() : "");
        return (Characteristic3D[])Client.getWebTarget().path(text).request().get(Characteristic3D[].class);
    }

    public static int saveOrUpdate(Transaction trx, Characteristic3D c3d) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)c3d));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void createMissingInstances(Transaction trx, Characteristic3D c3d) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/create_missing_instances/trx=%s&id=%d", PREFIX, trx, c3d.getId())).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static Characteristic3D getByName(Transaction trx, String variableName) {
        return (Characteristic3D)Client.getWebTarget().path(String.format("%s/get_by_name/trx=%s&var_name=%s", PREFIX, trx, variableName)).request().get(Characteristic3D.class);
    }
}

