/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class Characteristic3DInstanceDAO {
    public static final String PREFIX = "characteristic/3d_instance";

    public static Characteristic3DInstance get(Transaction trx, int id) {
        return (Characteristic3DInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Characteristic3DInstance.class);
    }

    public static Characteristic3DInstance get(Transaction trx, Characteristic3D characteristic3d, StructureObject structureObject) {
        return (Characteristic3DInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&c3d_id=%d&object_id=%d", PREFIX, trx, characteristic3d.getId(), structureObject.getId())).request().get(Characteristic3DInstance.class);
    }

    public static Characteristic3DInstance[] getAll(Transaction trx, Characteristic3D characteristic3d) {
        String path = String.format("%s/get_all/trx=%s&c3d_id=%d", PREFIX, trx, characteristic3d.getId());
        return (Characteristic3DInstance[])Client.getWebTarget().path(path).request().get(Characteristic3DInstance[].class);
    }

    public static int saveOrUpdate(Transaction trx, Characteristic3DInstance c3di) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)c3di));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void applyCurveValuesChanges(Transaction trx, Characteristic3DInstance instance, Characteristic3DFunctionChange[] changes) throws DAOOperationException {
        String url = String.format("%s/apply_curve_changes/trx=%s&id=%d", PREFIX, trx, instance.getId());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)changes));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

