/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3DRole;
import de.elpro.ewms.core.characteristic.ICharacteristic3DRole;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;

public class Characteristic3DRoleDAO {
    public static final String PREFIX = "characteristic/3d/role";

    public static Characteristic3DRole get(String id) {
        return (Characteristic3DRole)Client.getWebTarget().path(String.format("%s/get/id=%s", PREFIX, id)).request().get(Characteristic3DRole.class);
    }

    public static Characteristic3DRole[] getAll(Transaction trx) {
        return (Characteristic3DRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Characteristic3DRole[].class);
    }

    public static Characteristic3DRole[] getAll(Transaction trx, StructureClass structureClass) {
        return (Characteristic3DRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Characteristic3DRole[].class);
    }

    public static Characteristic3DRole[] getAll(Transaction trx, StructureClass structureClass, PhysicalUnit inputXAxisPhysicalUnit, PhysicalUnit inputYAxisPhysicalUnit, PhysicalUnit outputZAxisPhysicalUnit) {
        return Characteristic3DRoleDAO.getAll(trx, structureClass, inputXAxisPhysicalUnit, inputYAxisPhysicalUnit, outputZAxisPhysicalUnit, null);
    }

    public static Characteristic3DRole[] getAll(Transaction trx, StructureClass structureClass, PhysicalUnit inputXAxisPhysicalUnit, PhysicalUnit inputYAxisPhysicalUnit, PhysicalUnit outputZAxisPhysicalUnit, PhysicalUnit outputWAxisPhysicalUnit) {
        return (Characteristic3DRole[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&class_id=%d&input_x_axis_pu_key=%s&input_y_axis_pu_key=%s&output_z_axis_pu_key=%s&output_w_axis_pu_key=%s", PREFIX, trx, structureClass.getId(), inputXAxisPhysicalUnit.getKey(), inputYAxisPhysicalUnit.getKey(), outputZAxisPhysicalUnit.getKey(), outputWAxisPhysicalUnit != null ? outputWAxisPhysicalUnit.getKey() : "")).request().get(Characteristic3DRole[].class);
    }

    private static Characteristic3D getUniqueCharacteristic3DInternal(Transaction trx, String characteristic3DRoleId) {
        return (Characteristic3D)Client.getWebTarget().path(String.format("%s/get_characteristic_3d/trx=%s&role_id=%s", PREFIX, trx, characteristic3DRoleId)).request().get(Characteristic3D.class);
    }

    public static Characteristic3D getUniqueCharacteristic3D(Transaction trx, ICharacteristic3DRole characteristic3DRole) throws IllegalConfigException {
        Characteristic3D characteristic3D = Characteristic3DRoleDAO.getUniqueCharacteristic3DInternal(trx, characteristic3DRole.getId());
        if (characteristic3D == null) {
            throw new IllegalConfigException(String.format("No characteristic 3d instance for role '%s' found", Characteristic3DRoleDAO.toString(characteristic3DRole)));
        }
        return characteristic3D;
    }

    public static Characteristic3D getUniqueCharacteristic3D(Transaction trx, String characteristic3DRoleId) throws IllegalConfigException {
        Characteristic3D characteristic3D = Characteristic3DRoleDAO.getUniqueCharacteristic3DInternal(trx, characteristic3DRoleId);
        if (characteristic3D == null) {
            throw new IllegalConfigException(String.format("No characteristic 3d instance for role '%s' found", characteristic3DRoleId));
        }
        return characteristic3D;
    }

    private static Characteristic3DInstance getCharacteristic3dInstanceInternal(Transaction trx, String characteristic3DRoleId, StructureObject structureObject) {
        return (Characteristic3DInstance)Client.getWebTarget().path(String.format("%s/get_characteristic_3d_instance/trx=%s&role_id=%s&obj_id=%d", PREFIX, trx, characteristic3DRoleId, structureObject.getId())).request().get(Characteristic3DInstance.class);
    }

    public static Characteristic3DInstance getCharacteristic3dInstance(Transaction trx, ICharacteristic3DRole characteristic3DRole, StructureObject structureObject) throws IllegalConfigException {
        Characteristic3DInstance instance = Characteristic3DRoleDAO.getCharacteristic3dInstanceInternal(trx, characteristic3DRole.getId(), structureObject);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No characteristic 3d instance for role '%s' and object '%s' found", Characteristic3DRoleDAO.toString(characteristic3DRole), structureObject));
        }
        return instance;
    }

    public static Characteristic3DInstance getCharacteristic3dInstance(Transaction trx, String characteristic3DRoleId, StructureObject structureObject) throws IllegalConfigException {
        Characteristic3DInstance instance = Characteristic3DRoleDAO.getCharacteristic3dInstanceInternal(trx, characteristic3DRoleId, structureObject);
        if (instance == null) {
            throw new IllegalConfigException(String.format("No characteristic 3d instance for role '%s' and object '%s' found", characteristic3DRoleId, structureObject));
        }
        return instance;
    }

    public static Characteristic3DInstance getCharacteristic3dInstance(Transaction trx, String variableRoleId, String objectKey) {
        return (Characteristic3DInstance)Client.getWebTarget().path(String.format("%s/get_characteristic_3d_instance/trx=%s&role_id=%s&obj_key=%s", PREFIX, trx, variableRoleId, objectKey)).request().get(Characteristic3DInstance.class);
    }

    private static String toString(ICharacteristic3DRole role) {
        return String.format("%s [<%s,%s>~<%s%s>], Str.Class(%s)", role.getName(), role.getInputXAxisPhysicalUnit().getName(), role.getInputYAxisPhysicalUnit().getName(), role.getOutputZAxisPhysicalUnit().getName(), role.getOutputWAxisPhysicalUnit() != null ? "," + role.getOutputWAxisPhysicalUnit().getName() : "", role.getClassRoleId());
    }
}

