/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class Characteristic3DSeriesDAO {
    private static final String PREFIX = "charts/characteristic3d_series";

    public static Characteristic3DSeries getByChart(Transaction trx, Chart3D chart) {
        return (Characteristic3DSeries)Client.getWebTarget().path(String.format("%s/get_by_chart/trx=%s&chart_id=%d", PREFIX, trx, chart.getId())).request().get(Characteristic3DSeries.class);
    }

    public static void saveOrUpdate(Transaction trx, Characteristic3DSeries series) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)series));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void delete(Transaction trx, int chartId) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&chart_id=%d", PREFIX, trx, chartId)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

