/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.charts.Characteristic3DSeriesDAO;
import de.elpro.ewms.core.client.charts.FunctionSeries3DDAO;
import de.elpro.ewms.core.client.charts.VarSeries3DDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class Chart3DDAO {
    private static final String PREFIX = "charts/chart3d";

    public static Chart3D get(Transaction trx, int id) {
        return (Chart3D)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Chart3D.class);
    }

    public static Chart3D[] getAll(Transaction trx) {
        return (Chart3D[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Chart3D[].class);
    }

    public static Chart3D loadNormalized(Transaction trx, int id) {
        VarSeries3D series;
        Chart3D chart = Chart3DDAO.get(trx, id);
        if (chart.getDataStructureClass() != null) {
            chart.setDataStructureClass(StructureClassDAO.get(trx, chart.getDataStructureClass().getId()));
        }
        chart.getVarSeries().clear();
        VarSeries3D[] varSeries3DArray = VarSeries3DDAO.getByChart(trx, chart);
        int n = varSeries3DArray.length;
        int n2 = 0;
        while (n2 < n) {
            series = varSeries3DArray[n2];
            if (series.getXAxisVariable() != null && series.getYAxisVariable() != null && series.getZAxisVariable() != null) {
                series.setXAxisVariable(VariableDAO.get(trx, series.getXAxisVariable().getId()));
                if (series.getXAxisVariableInstance() != null) {
                    series.setXAxisVariableInstance(VariableInstanceDAO.get(trx, series.getXAxisVariableInstance().getId()));
                }
                series.setYAxisVariable(VariableDAO.get(trx, series.getYAxisVariable().getId()));
                if (series.getYAxisVariableInstance() != null) {
                    series.setYAxisVariableInstance(VariableInstanceDAO.get(trx, series.getYAxisVariableInstance().getId()));
                }
                series.setZAxisVariable(VariableDAO.get(trx, series.getZAxisVariable().getId()));
                if (series.getZAxisVariableInstance() != null) {
                    series.setZAxisVariableInstance(VariableInstanceDAO.get(trx, series.getZAxisVariableInstance().getId()));
                }
                if (chart.getWAxisType() == Chart3DWAxisType.Variable && series.getWAxisVariable() != null) {
                    series.setWAxisVariable(VariableDAO.get(trx, series.getWAxisVariable().getId()));
                    if (series.getWAxisVariableInstance() != null) {
                        series.setWAxisVariableInstance(VariableInstanceDAO.get(trx, series.getWAxisVariableInstance().getId()));
                    }
                }
                chart.getVarSeries().add(series);
            }
            ++n2;
        }
        chart.getFunctionSeries().clear();
        varSeries3DArray = FunctionSeries3DDAO.getByChart(trx, chart);
        n = varSeries3DArray.length;
        n2 = 0;
        while (n2 < n) {
            series = varSeries3DArray[n2];
            chart.getFunctionSeries().add(series);
            ++n2;
        }
        if (chart.getCharacteristic3DSeries() != null) {
            Characteristic3DSeries c3ds = Characteristic3DSeriesDAO.getByChart(trx, chart);
            chart.setCharacteristic3DSeries(c3ds);
            Characteristic3D c3d = Characteristic3DDAO.get(trx, c3ds.getCharacteristic().getId());
            c3ds.setCharacteristic(c3d);
        }
        return chart;
    }

    public static Chart3D[] getUngrouped(Transaction trx) {
        return (Chart3D[])Client.getWebTarget().path(String.format("%s/get_ungrouped/trx=%s", PREFIX, trx)).request().get(Chart3D[].class);
    }

    public static Chart3D[] getByGroup(Transaction trx, ChartGroup group) {
        return (Chart3D[])Client.getWebTarget().path(String.format("%s/get_by_group/trx=%s&group_id=%d", PREFIX, trx, group.getId())).request().get(Chart3D[].class);
    }

    public static Chart3D[] findByDataClass(Transaction trx, StructureClass structureClass) {
        return (Chart3D[])Client.getWebTarget().path(String.format("%s/find_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Chart3D[].class);
    }

    public static int saveOrUpdate(Transaction trx, Chart3D chart) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)chart));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

