/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import com.google.common.collect.LinkedHashMultimap;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.charts.SankeyNodeDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class SankeyChartDAO {
    private static final String PREFIX = "charts/sankey_chart";

    public static SankeyChart get(Transaction trx, int id) {
        return (SankeyChart)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(SankeyChart.class);
    }

    public static SankeyChart loadNormalized(Transaction trx, int id) {
        SankeyChart chart = SankeyChartDAO.get(trx, id);
        LinkedHashMultimap childNodes = LinkedHashMultimap.create();
        HashMap<Integer, SankeyNode> nodes = new HashMap<Integer, SankeyNode>();
        SankeyNode[] sankeyNodeArray = SankeyNodeDAO.getAllNodes(trx, chart);
        int n = sankeyNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SankeyNode child = sankeyNodeArray[n2];
            child.setVariable(VariableDAO.get(trx, child.getVariable().getId()));
            nodes.put(child.getId(), child);
            childNodes.put((Object)child.getParentNode(), (Object)child);
            ++n2;
        }
        for (SankeyNode rootNode : childNodes.get(null)) {
            chart.getRootNodes().add(rootNode);
        }
        for (SankeyNode parentNode : childNodes.keys()) {
            if (parentNode == null) continue;
            parentNode = (SankeyNode)nodes.get(parentNode.getId());
            parentNode.getChildren().clear();
            parentNode.getChildren().addAll(childNodes.get((Object)parentNode));
        }
        return chart;
    }

    public static SankeyChart[] getUngrouped(Transaction trx) {
        return (SankeyChart[])Client.getWebTarget().path(String.format("%s/get_ungrouped/trx=%s", PREFIX, trx)).request().get(SankeyChart[].class);
    }

    public static SankeyChart[] getByGroup(Transaction trx, ChartGroup group) {
        return (SankeyChart[])Client.getWebTarget().path(String.format("%s/get_by_group/trx=%s&group_id=%d", PREFIX, trx, group.getId())).request().get(SankeyChart[].class);
    }

    public static SankeyChart[] findByClass(Transaction trx, StructureClass structureClass) {
        return (SankeyChart[])Client.getWebTarget().path(String.format("%s/find_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(SankeyChart[].class);
    }

    public static int saveOrUpdate(Transaction trx, SankeyChart chart) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)chart));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

