/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class SeriesGroupDAO {
    private static final String PREFIX = "charts/seriesgroup";

    public static SeriesGroup get(Transaction trx, int id) {
        return (SeriesGroup)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(SeriesGroup.class);
    }

    public static SeriesGroup[] getByYAxis(Transaction trx, YAxis yAxis) {
        return (SeriesGroup[])Client.getWebTarget().path(String.format("%s/get_by_yaxis/trx=%s&yaxis_id=%d", PREFIX, trx, yAxis.getId())).request().get(SeriesGroup[].class);
    }

    public static int saveOrUpdate(Transaction trx, SeriesGroup seriesGroup) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)seriesGroup));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

