/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class VarSeriesDAO {
    private static final String PREFIX = "charts/chart2d/var_series";

    public static VarSeries2D get(Transaction trx, int id) {
        return (VarSeries2D)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(VarSeries2D.class);
    }

    public static VarSeries2D[] getBySeriesGroup(Transaction trx, SeriesGroup seriesGroup) {
        return (VarSeries2D[])Client.getWebTarget().path(String.format("%s/get_by_seriesgroup/trx=%s&group_id=%d", PREFIX, trx, seriesGroup.getId())).request().get(VarSeries2D[].class);
    }

    public static VarSeries2D[] getUngroupedByYAxis(Transaction trx, YAxis yAxis) {
        return (VarSeries2D[])Client.getWebTarget().path(String.format("%s/get_ungrouped_by_yaxis/trx=%s&yaxis_id=%d", PREFIX, trx, yAxis.getId())).request().get(VarSeries2D[].class);
    }

    public static int saveOrUpdate(Transaction trx, VarSeries2D varSeries) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)varSeries));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

