/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class YAxisDAO {
    private static final String PREFIX = "charts/chart2d/yaxis";

    public static YAxis get(Transaction trx, int id) {
        return (YAxis)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(YAxis.class);
    }

    public static YAxis[] getByChart(Transaction trx, Chart2D chart) {
        return (YAxis[])Client.getWebTarget().path(String.format("%s/get_by_chart/trx=%s&chart_id=%d", PREFIX, trx, chart.getId())).request().get(YAxis[].class);
    }

    public static int saveOrUpdate(Transaction trx, YAxis yAxis) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)yAxis));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

