/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.datasource;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.VariableInstance;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class DataGroupDAO {
    private static final String PREFIX = "datasource/source/datasource/datagroup";

    public static DataGroup get(Transaction trx, int id) {
        return (DataGroup)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(DataGroup.class);
    }

    public static DataGroup[] getByDataSource(Transaction trx, DataSource ds) {
        return (DataGroup[])Client.getWebTarget().path(String.format("%s/get_by_datasource/trx=%s&ds_id=%d", PREFIX, trx, ds.getId())).request().get(DataGroup[].class);
    }

    public static DataGroup[] getAll(Transaction trx) {
        return (DataGroup[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(DataGroup[].class);
    }

    public static int saveOrUpdate(Transaction trx, DataGroup dataGroup) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)dataGroup));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static VariableInstance[] getAllVarInstances(Transaction trx, int id) {
        return (VariableInstance[])Client.getWebTarget().path(String.format("%s/get_all_varinstances/trx=%s&id=%s", PREFIX, trx, id)).request().get(VariableInstance[].class);
    }

    public static void restartBackgroundWorker(int dataGroupId) {
        Client.getWebTarget().path(String.format("%s/background_worker/restart/data_group_id=%d", PREFIX, dataGroupId)).request().get();
    }
}

