/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.datasource;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.bundle.Activator;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.eclipse.fx.core.log.Logger;

public class DataSourceAltDAO {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataSourceAltDAO.class.getName());
    private static final String PREFIX = "datasource/source_alt";

    public static DataSourceAlt get(Transaction trx, int id) {
        DataSourceAlt ret = (DataSourceAlt)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(DataSourceAlt.class);
        return ret;
    }

    public static DataSourceAlt[] getAll(Transaction trx) {
        DataSourceAlt[] ret = (DataSourceAlt[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(DataSourceAlt[].class);
        return ret;
    }

    public static DataSourceAlt[] getAll(Transaction trx, DataSource dataSource) {
        DataSourceAlt[] ret = (DataSourceAlt[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&datasource_id=%d", PREFIX, trx, dataSource.getId())).request().get(DataSourceAlt[].class);
        return ret;
    }

    public static int saveOrUpdate(Transaction trx, DataSourceAlt dataSourceAlt) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)dataSourceAlt));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

