/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.dataview;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ViewNodeDAO {
    private static final String PREFIX = "dataview/node";

    public static ViewNode get(Transaction trx, int id) {
        return (ViewNode)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ViewNode.class);
    }

    public static ViewNode[] getAll(Transaction trx) {
        return (ViewNode[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(ViewNode[].class);
    }

    public static int saveOrUpdate(Transaction trx, ViewNode vp) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)vp));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static ViewNode[] getChildren(Transaction trx, ViewNode parentNode) {
        return (ViewNode[])Client.getWebTarget().path(String.format("%s/get_children/trx=%s&id=%s", PREFIX, trx, parentNode.getId())).request().get(ViewNode[].class);
    }
}

