/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.dataview;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ViewPerspectiveDAO {
    private static final String PREFIX = "dataview/perspective";

    public static ViewPerspective get(Transaction trx, int id) {
        return (ViewPerspective)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ViewPerspective.class);
    }

    public static ViewPerspective[] getAll(Transaction trx) {
        return (ViewPerspective[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(ViewPerspective[].class);
    }

    public static ViewPerspective[] getByTargetPartStack(Transaction trx, String targetPartStatckId) {
        return (ViewPerspective[])Client.getWebTarget().path(String.format("%s/get_by_target/trx=%s&target_id=%s", PREFIX, trx, targetPartStatckId)).request().get(ViewPerspective[].class);
    }

    public static int saveOrUpdate(Transaction trx, ViewPerspective vp) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)vp));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static ViewNode[] getRootNodes(Transaction trx, ViewPerspective perspective) {
        return (ViewNode[])Client.getWebTarget().path(String.format("%s/get_root_nodes/trx=%s&id=%s", PREFIX, trx, perspective.getId())).request().get(ViewNode[].class);
    }
}

