/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.locale;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.locale.LocaleDefinition;
import de.elpro.ui.text.LocaleDescriptor;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class LocaleDefinitionDAO {
    private static final String PREFIX = "locale/localedefinition";

    public static LocaleDefinition get(Transaction trx, int id) {
        return (LocaleDefinition)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(LocaleDefinition.class);
    }

    public static LocaleDefinition[] getAll(Transaction trx) {
        return (LocaleDefinition[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(LocaleDefinition[].class);
    }

    public static LocaleDefinition[] getFallbackLocales(Transaction trx) {
        return (LocaleDefinition[])Client.getWebTarget().path(String.format("%s/get_fallback_locales/trx=%s", PREFIX, trx)).request().get(LocaleDefinition[].class);
    }

    public static LocaleDescriptor[] getDescriptors(Transaction trx) {
        LocaleDefinition[] lds = (LocaleDefinition[])Client.getWebTarget().path(String.format("%s/get_all_visible/trx=%s", PREFIX, trx)).request().get(LocaleDefinition[].class);
        LocaleDescriptor[] descriptors = new LocaleDescriptor[lds.length];
        int i = 0;
        while (i < lds.length) {
            descriptors[i] = lds[i].toDescriptor();
            ++i;
        }
        return descriptors;
    }

    public static int saveOrUpdate(Transaction trx, LocaleDefinition vp) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)vp));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

