/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.preferences;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.bundle.Activator;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.eclipse.fx.core.log.Logger;

public class Preferences {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Preferences.class.getName());

    public static VirtualZone getVirtualZone() {
        return (VirtualZone)Client.getWebTarget().path("preferences/virtualzone/get").request().get(VirtualZone.class);
    }

    public static boolean setVirtualZone(VirtualZone virtualZone) {
        try {
            Response respose = Client.getWebTarget().path("preferences/virtualzone/set").request().post(Entity.json((Object)virtualZone));
            return respose.getStatus() == Response.Status.OK.getStatusCode();
        }
        catch (Exception exc) {
            logger.error("Error reading virtualzone definition", (Throwable)exc);
            return false;
        }
    }

    public static Raster getGlobalViewRaster() {
        try {
            return (Raster)Client.getWebTarget().path("preferences/realtimeviewraster/get").request().get(Raster.class);
        }
        catch (Exception exc) {
            logger.error("Error reading low resolution raster", (Throwable)exc);
            return null;
        }
    }

    public static Raster getRealtimeViewRaster() {
        try {
            return (Raster)Client.getWebTarget().path("preferences/globalviewraster/get").request().get(Raster.class);
        }
        catch (Exception exc) {
            logger.error("Error reading high resolution raster", (Throwable)exc);
            return null;
        }
    }
}

