/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.report;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.report.TableReportConfigDAO;
import de.elpro.ewms.core.client.report.TableReportDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import java.util.Arrays;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ReportProfileDAO {
    private static final String PREFIX = "report/profile";

    public static ReportProfile get(Transaction trx, int id) {
        return (ReportProfile)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ReportProfile.class);
    }

    public static ReportProfile loadNormalized(Transaction trx, int id) {
        ReportProfile profile = ReportProfileDAO.get(trx, id);
        if (profile == null) {
            return null;
        }
        profile.getTableReports().clear();
        profile.getTableReports().addAll(Arrays.asList(TableReportDAO.getByProfile(trx, profile)));
        for (TableReport tableReport : profile.getTableReports()) {
            tableReport.setTable(TableDAO.get(trx, tableReport.getTable().getId()));
            tableReport.getConfigs().clear();
            tableReport.getConfigs().addAll(Arrays.asList(TableReportConfigDAO.getByTableReport(trx, tableReport)));
            for (TableReportConfig tableReportConfig : tableReport.getConfigs()) {
                tableReportConfig.setTableReport(tableReport);
                tableReportConfig.setStructureObject(StructureObjectDAO.get(trx, (int)tableReportConfig.getStructureObject().getId()));
            }
        }
        return profile;
    }

    public static ReportProfile[] getAll(Transaction trx) {
        return (ReportProfile[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(ReportProfile[].class);
    }

    public static int saveOrUpdate(Transaction trx, ReportProfile profile) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)profile));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

