/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.schedules;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.schedules.JobDescriptor;
import de.elpro.ewms.core.schedules.Schedule;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ScheduleDAO {
    private static final String PREFIX = "schedules/schedule";

    public static Schedule get(Transaction trx, int id) {
        return (Schedule)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Schedule.class);
    }

    public static Schedule[] getAll(Transaction trx) {
        return (Schedule[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Schedule[].class);
    }

    public static JobDescriptor[] getJobDescriptors() {
        return (JobDescriptor[])Client.getWebTarget().path(String.format("%s/get_job_descriptors", PREFIX)).request().get(JobDescriptor[].class);
    }

    public static void executeSync(Schedule schedule) throws DAOOperationException {
        String url = String.format("%s/execute_sync/id=%d", PREFIX, schedule.getId());
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static int saveOrUpdate(Transaction trx, Schedule schedule) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)schedule));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

