/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.structure;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class PropertyGroupDAO {
    private static final String PREFIX = "structure/propertygroup";

    public static PropertyGroup get(Transaction trx, String key) {
        return (PropertyGroup)Client.getWebTarget().path(String.format("%s/get/trx=%s&key=%s", PREFIX, trx, key)).request().get(PropertyGroup.class);
    }

    public static PropertyGroup[] getByStructureClass(Transaction trx, StructureClass structureClass) {
        return (PropertyGroup[])Client.getWebTarget().path(String.format("%s/get_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(PropertyGroup[].class);
    }

    public static PropertyGroup[] getAllByStructureClass(Transaction trx, StructureClass structureClass) {
        return (PropertyGroup[])Client.getWebTarget().path(String.format("%s/get_all_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(PropertyGroup[].class);
    }

    public static void saveOrUpdate(Transaction trx, PropertyGroup propertyGroup) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)propertyGroup));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void delete(Transaction trx, String key) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&key=%s", PREFIX, trx, key)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

