/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.structure;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class StructureClassDAO {
    private static final String PREFIX = "structure/class";

    public static StructureClass get(Transaction trx, int id) {
        return (StructureClass)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureClass.class);
    }

    public static StructureClass[] getRootClasses(Transaction trx) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_roots/trx=%s", PREFIX, trx)).request().get(StructureClass[].class);
    }

    public static StructureClass[] getAll(Transaction trx) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(StructureClass[].class);
    }

    public static StructureClass[] getAllExtendClasses(Transaction trx, int id) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_all_extenders/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureClass[].class);
    }

    public static StructureClass[] getAllParentClasses(Transaction trx, int id) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_all_parents/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureClass[].class);
    }

    public static Variable[] getAllVariables(Transaction trx, int id) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get_all_variables/trx=%s&id=%d", PREFIX, trx, id)).request().get(Variable[].class);
    }

    public static Variable[] getAllVariables(Transaction trx, StructureClass structureClass) {
        return StructureClassDAO.getAllVariables(trx, structureClass.getId());
    }

    public static StructureObject[] getAllObjects(Transaction trx, int id) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all_objects/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureObject[].class);
    }

    public static StructureObject[] getAllObjects(Transaction trx, StructureClass structureClass) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all_objects/trx=%s&id=%d", PREFIX, trx, structureClass.getId())).request().get(StructureObject[].class);
    }

    public static Collection<StructureObject> getAllObjects(StructureClass structureClass) {
        if (structureClass == null) {
            return Collections.emptyList();
        }
        Transaction trx = Transactions.begin();
        try {
            List<StructureObject> list = Arrays.asList(StructureClassDAO.getAllObjects(trx, structureClass));
            return list;
        }
        finally {
            Transactions.close(trx);
        }
    }

    public static StructureClass[] getAllConnectionParents(Transaction trx, int id) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_all_connection_parents/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureClass[].class);
    }

    public static StructureObject[] getAllowedParentObjects(Transaction trx, int id) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all_allowed_parent_objects/trx=%s&id=%d", PREFIX, trx, id)).request().get(StructureObject[].class);
    }

    public static boolean isSubclass(Transaction trx, StructureClass parentClass, StructureClass childClass) {
        if (parentClass.getId() == childClass.getId()) {
            return true;
        }
        return (Boolean)Client.getWebTarget().path(String.format("%s/is_subclass/trx=%s&parent_id=%d&child_id=%d", PREFIX, trx, parentClass.getId(), childClass.getId())).request().get(Boolean.class);
    }

    public static int saveOrUpdate(Transaction trx, StructureClass structureClass) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)structureClass));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

