/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.tables;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ColumnGroupDAO {
    private static final String PREFIX = "tables/columngroup";

    public static ColumnGroup get(Transaction trx, int id) {
        return (ColumnGroup)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ColumnGroup.class);
    }

    public static Column[] getColumns(Transaction trx, ColumnGroup columnGroup) {
        return (Column[])Client.getWebTarget().path(String.format("%s/get_columns/trx=%s&id=%d", PREFIX, trx, columnGroup.getId())).request().get(Column[].class);
    }

    public static ColumnGroup[] getChildColumnGroups(Transaction trx, ColumnGroup columnGroup) {
        return (ColumnGroup[])Client.getWebTarget().path(String.format("%s/get_child_columngroups/trx=%s&id=%d", PREFIX, trx, columnGroup.getId())).request().get(ColumnGroup[].class);
    }

    public static int saveOrUpdate(Transaction trx, ColumnGroup columnGroup) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)columnGroup));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

