/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.tables;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.tables.ColumnGroupDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.Table;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class TableDAO {
    private static final String PREFIX = "tables/table";

    public static Table get(Transaction trx, int id) {
        return (Table)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Table.class);
    }

    public static Table loadNormalized(Transaction trx, int id) {
        Table table = TableDAO.get(trx, id);
        table.getColumns().clear();
        table.getColumnGroups().clear();
        Column[] columnArray = TableDAO.getRootColumns(trx, table);
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column rootColumn = columnArray[n2];
            TableDAO.loadColumn(trx, rootColumn);
            table.getRootColumns().add(rootColumn);
            table.getColumns().add(rootColumn);
            ++n2;
        }
        columnArray = TableDAO.getRootColumnGroups(trx, table);
        n = columnArray.length;
        n2 = 0;
        while (n2 < n) {
            Column rootColumnGroup = columnArray[n2];
            TableDAO.loadColumnGroupRecursive(trx, table, (ColumnGroup)rootColumnGroup);
            table.getRootColumnGroups().add(rootColumnGroup);
            table.getColumnGroups().add(rootColumnGroup);
            ++n2;
        }
        return table;
    }

    private static void loadColumn(Transaction trx, Column column) {
        if (column.getVariable() != null) {
            column.setVariable(VariableDAO.get(trx, column.getVariable().getId()));
        }
        if (column.getVariableInstance() != null) {
            column.setVariableInstance(VariableInstanceDAO.get(trx, column.getVariableInstance().getId()));
            column.getVariableInstance().setVariable(column.getVariable());
        }
    }

    private static void loadColumnGroupRecursive(Transaction trx, Table table, ColumnGroup columnGroup) {
        columnGroup.getColumnGroups().clear();
        columnGroup.getColumns().clear();
        Column[] columnArray = ColumnGroupDAO.getColumns(trx, columnGroup);
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            column.setColumnGroup(columnGroup);
            TableDAO.loadColumn(trx, column);
            columnGroup.getColumns().add(column);
            table.getColumns().add(column);
            ++n2;
        }
        columnArray = ColumnGroupDAO.getChildColumnGroups(trx, columnGroup);
        n = columnArray.length;
        n2 = 0;
        while (n2 < n) {
            Column childColumnGroup = columnArray[n2];
            childColumnGroup.setParentGroup(columnGroup);
            TableDAO.loadColumnGroupRecursive(trx, table, (ColumnGroup)childColumnGroup);
            columnGroup.getColumnGroups().add(childColumnGroup);
            table.getColumnGroups().add(childColumnGroup);
            ++n2;
        }
    }

    public static Table[] getAll(Transaction trx) {
        return (Table[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Table[].class);
    }

    public static Table[] getByClass(Transaction trx, StructureClass structureClass) {
        return (Table[])Client.getWebTarget().path(String.format("%s/get_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Table[].class);
    }

    public static Table[] findByClass(Transaction trx, StructureClass structureClass) {
        return (Table[])Client.getWebTarget().path(String.format("%s/find_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Table[].class);
    }

    public static Table findByRole(Transaction trx, String roleKey) {
        return (Table)Client.getWebTarget().path(String.format("%s/find_by_role/trx=%s&role_key=%s", PREFIX, trx, roleKey)).request().get(Table.class);
    }

    public static Column[] getRootColumns(Transaction trx, Table table) {
        return (Column[])Client.getWebTarget().path(String.format("%s/get_root_columns/trx=%s&id=%d", PREFIX, trx, table.getId())).request().get(Column[].class);
    }

    public static ColumnGroup[] getRootColumnGroups(Transaction trx, Table table) {
        return (ColumnGroup[])Client.getWebTarget().path(String.format("%s/get_root_columngroups/trx=%s&id=%d", PREFIX, trx, table.getId())).request().get(ColumnGroup[].class);
    }

    public static int saveOrUpdate(Transaction trx, Table table) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)table));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

