/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.time;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.time.PhaseTypeDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.time.TimelinePhase;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedList;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class TimelinePhaseDAO {
    private static final String PREFIX = "timeline/phase";

    public static TimelinePhase get(Transaction trx, int id) {
        TimelinePhase phase = (TimelinePhase)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(TimelinePhase.class);
        if (phase != null && phase.getType() != null) {
            phase.setType(PhaseTypeDAO.get(trx, phase.getType().getId()));
        }
        return phase;
    }

    public static TimelinePhase[] getAll(Transaction trx) {
        return (TimelinePhase[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(TimelinePhase[].class);
    }

    public static TimelinePhase[] getAll(Transaction trx, Timeline timeline) {
        return (TimelinePhase[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&timeline_key=%s", PREFIX, trx, timeline.getKey())).request().get(TimelinePhase[].class);
    }

    public static Collection<TimelinePhase> getAll(Transaction trx, Timeline timeline, LocalDate filterFrom, LocalDate filterTo) {
        LinkedList<TimelinePhase> phases = new LinkedList<TimelinePhase>();
        TimelinePhase lastPhase = null;
        if (timeline != null) {
            TimelinePhase[] timelinePhaseArray = TimelinePhaseDAO.getAll(trx, timeline);
            int n = timelinePhaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimelinePhase phase = timelinePhaseArray[n2];
                phase.setType(PhaseTypeDAO.get(trx, phase.getType().getId()));
                if (lastPhase != null && lastPhase.getFrom().isBefore(filterTo) && !filterFrom.isAfter(phase.getFrom())) {
                    phases.add(lastPhase);
                }
                lastPhase = phase;
                ++n2;
            }
            if (lastPhase != null && !filterTo.isBefore(lastPhase.getFrom())) {
                phases.add(lastPhase);
            }
        }
        return phases;
    }

    public static int saveOrUpdate(Transaction trx, TimelinePhase timelinePhase) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)timelinePhase));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

