/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.variable;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Specialization;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class SpecializationDAO {
    public static final String PREFIX = "specialization";

    public static Specialization get(Transaction trx, int id) {
        return (Specialization)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%s", PREFIX, trx, id)).request().get(Specialization.class);
    }

    public static Specialization[] getAll(Transaction trx) {
        return (Specialization[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Specialization[].class);
    }

    public static int saveOrUpdate(Transaction trx, Specialization specialization) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)specialization));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%s", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

