/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.variable;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class VariableDAO {
    public static final String PREFIX = "variable";

    public static Variable get(Transaction trx, int id) {
        return (Variable)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Variable.class);
    }

    public static Variable[] get(Transaction trx, int[] ids) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get/trx=%s", PREFIX, trx)).request().post(Entity.json((Object)ids)).readEntity(Variable[].class);
    }

    public static Map<Integer, Variable> getAsMap(Transaction trx, int[] ids) {
        Variable[] variables = VariableDAO.get(trx, ids);
        HashMap<Integer, Variable> map = new HashMap<Integer, Variable>();
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            map.put(var.getId(), var);
            ++n2;
        }
        return map;
    }

    public static Variable[] getAll(Transaction trx) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(Variable[].class);
    }

    public static Variable[] getAll(Transaction trx, PhysicalUnit physicalUnit) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&physical_unit_id=%s", PREFIX, trx, PhysicalUnit.CONVERTER.toString((Object)physicalUnit))).request().get(Variable[].class);
    }

    public static Variable[] getByClass(Transaction trx, StructureClass structureClass) {
        return (Variable[])Client.getWebTarget().path(String.format("%s/get_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Variable[].class);
    }

    public static Variable getByName(Transaction trx, String variableName) {
        return (Variable)Client.getWebTarget().path(String.format("%s/get_by_name/trx=%s&var_name=%s", PREFIX, trx, variableName)).request().get(Variable.class);
    }

    public static VariableInstance[] findInstances(Transaction trx, Variable var, StructureObject object) {
        return VariableDAO.findInstances(trx, var, object, SearchPolicy.Auto);
    }

    public static VariableInstance[] findInstances(Transaction trx, Variable var, StructureObject object, SearchPolicy searchPolicy) {
        return (VariableInstance[])Client.getWebTarget().path(String.format("%s/find_over_object_tree/trx=%s&var_id=%d&object_id=%d&policy=%s", PREFIX, trx, var.getId(), object.getId(), searchPolicy != null ? searchPolicy.name() : "")).request().get(VariableInstance[].class);
    }

    public static int saveOrUpdate(Transaction trx, Variable variable) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)variable));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void updateVariableInstances(Transaction trx, Variable variable, VariableInstanceType type, SupplementValueStrategy strategy) throws DAOOperationException {
        OperationResult result;
        if (type == null) {
            type = VariableInstanceType.None;
        }
        if ((result = (OperationResult)Client.getWebTarget().path(String.format("%s/update_variable_instances/trx=%s&id=%d&type=%s&supplement_value_strategy=%s", PREFIX, trx, variable.getId(), type.name(), strategy != null ? strategy.name() : "")).request().get(OperationResult.class)).getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

