/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.variable;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeIntervalStringValueCollection;
import de.elpro.ewms.core.time.VariableInstanceTimeIntervalStringValues;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.DValArray;
import de.elpro.ewms.core.variable.value.GetValuesRequest;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class VariableInstanceDAO {
    private static final String PREFIX = "variable/instance";

    public static VariableInstance get(Transaction trx, int id) {
        return (VariableInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(VariableInstance.class);
    }

    public static VariableInstance get(Transaction trx, Variable var, StructureObject object) {
        return (VariableInstance)Client.getWebTarget().path(String.format("%s/get/trx=%s&var_id=%d&obj_id=%d", PREFIX, trx, var.getId(), object.getId())).request().get(VariableInstance.class);
    }

    public static VariableInstance[] getAll(Transaction trx) {
        return (VariableInstance[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(VariableInstance[].class);
    }

    public static VariableInstance[] getAll(Transaction trx, Variable var) {
        return VariableInstanceDAO.getAll(trx, var, false);
    }

    public static VariableInstance[] getAll(Transaction trx, Variable var, boolean loadObjects) {
        Object[] instances = (VariableInstance[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&var_id=%d", PREFIX, trx, var.getId())).request().get(VariableInstance[].class);
        if (loadObjects) {
            VariableInstanceDAO.loadStructureObjects(trx, (VariableInstance[])instances);
            Arrays.sort(instances);
        }
        return instances;
    }

    public static VariableInstance[] getAll(Transaction trx, StructureObject structureObject) {
        return (VariableInstance[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s&object_id=%d", PREFIX, trx, structureObject.getId())).request().get(VariableInstance[].class);
    }

    public static VariableInstance[] getAll(Transaction trx, Variable var, StructureObject[] objects) {
        int[] ids = new int[objects.length];
        int i = 0;
        while (i < objects.length) {
            ids[i] = objects[i].getId();
            ++i;
        }
        String url = String.format("%s/get_all/trx=%s&var_id=%d", PREFIX, trx, var.getId());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (VariableInstance[])response.readEntity(VariableInstance[].class);
    }

    public static void loadStructureObjects(Transaction trx, VariableInstance[] instances) {
        int[] objIds = Arrays.stream(instances).mapToInt(i -> i.getStructureObject().getId()).toArray();
        StructureObject[] objects = StructureObjectDAO.get(trx, objIds);
        int i2 = 0;
        while (i2 < instances.length) {
            instances[i2].setStructureObject(objects[i2]);
            ++i2;
        }
    }

    public static VariableInstance[] find(Transaction trx, StructureObject structureObject, VariableReference variableReference) {
        return (VariableInstance[])Client.getWebTarget().path(String.format("%s/find_by_var_reference/trx=%s&object_id=%d&search_policy=%s&var_name=%s", PREFIX, trx, structureObject.getId(), variableReference.getSearchPolicy().name(), variableReference.getVariableName())).request().get(VariableInstance[].class);
    }

    public static int saveOrUpdate(Transaction trx, VariableInstance instance) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)instance));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void setDatasource(Transaction trx, int id, int dataGroupId, String datasourceKey) throws DAOOperationException {
        String url = String.format("%s/set_datasource/trx=%s&id=%d&data_group_id=%d&datasource_key=%s", PREFIX, trx, id, dataGroupId, datasourceKey);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void changeInstanceType(Transaction trx, VariableInstanceType newType, Collection<VariableInstance> instances) throws DAOOperationException {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (VariableInstance instance : instances) {
            ids.add(instance.getId());
        }
        String url = String.format("%s/change_type/trx=%s&type=%s", PREFIX, trx, newType.name());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids.toArray(new Integer[0])));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void changeInstanceSupplementValuesStrategy(Transaction trx, SupplementValueStrategy strategy, Collection<VariableInstance> instances) throws DAOOperationException {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (VariableInstance instance : instances) {
            ids.add(instance.getId());
        }
        String url = String.format("%s/change_supplement_strategy/trx=%s&strategy=%s", PREFIX, trx, strategy != null ? strategy.name() : "");
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids.toArray(new Integer[0])));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static OperationResult convertPLCValues(VariableInstance[] instances, MeasuringUnit fromMU, MeasuringUnit toMU) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/convert_plc_values/pu_key=%s&from_mu_key=%s&to_mu_key=%s", PREFIX, fromMU.getPhysicalUnit().getKey(), fromMU.getKey(), toMU.getKey());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (OperationResult)response.readEntity(OperationResult.class);
    }

    public static ArchiveValue[] getArchiveValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant from, Instant to) {
        String url = String.format("%s/archivevalues/get/view_type=%s&view_index=%s&id=%d&from=%s&to=%s", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "", instanceId, from != null ? Long.toString(from.toEpochMilli()) : "", to != null ? Long.toString(to.toEpochMilli()) : "");
        return (ArchiveValue[])Client.getWebTarget().path(url).request().get(ArchiveValue[].class);
    }

    public static void importArchiveValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, ArchiveValue[] values) {
        String url = String.format("%s/archivevalues/import/view_type=%s&view_index=%s&id=%d", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "", instanceId);
        Client.getWebTarget().path(url).request().post(Entity.json((Object)values));
    }

    public static IVarValue[] getVarValue(RawValuesViewType viewType, Integer viewIndex, VariableInstance[] instances, Instant to) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/varvalue/get/view_type=%s&view_index=%s&to=%d", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "", to != null ? Long.valueOf(to.toEpochMilli()) : "");
        VarInstanceValuesCollectionMap collectionMap = (VarInstanceValuesCollectionMap)Client.getWebTarget().path(url).request().post(Entity.json((Object)ids)).readEntity(VarInstanceValuesCollectionMap.class);
        IVarValue[] result = new IVarValue[instances.length];
        int i2 = 0;
        while (i2 < instances.length) {
            IVarValue value;
            VariableInstance instance = instances[i2];
            result[i2] = value = collectionMap.getValues(instance).getLast();
            ++i2;
        }
        return result;
    }

    public static IVarValue getVarValue(RawValuesViewType viewType, Integer viewIndex, VariableInstance instance, Instant to) {
        return VariableInstanceDAO.getVarValue(viewType, viewIndex, instance.getId(), to);
    }

    public static IVarValue getVarValue(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant to) {
        String url = String.format("%s/varvalue/get/view_type=%s&view_index=%s&id=%d&to=%d", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "", instanceId, to != null ? Long.valueOf(to.toEpochMilli()) : "");
        return ((IVarValuesCollection)Client.getWebTarget().path(url).request().get(IVarValuesCollection.class)).getFirst();
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, int instanceId) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instanceId, null);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, ComplexRaster virtualRaster) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instanceId, null, null, virtualRaster, null);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance instance, Instant from, Instant to) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instance.getId(), from, to);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant from, Instant to) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instanceId, from, to, null);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance instance, Instant from, Instant to, ComplexRaster raster) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instance, from, to, raster, null);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance instance, Instant from, Instant to, ComplexRaster raster, Aggregation aggregation) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instance.getId(), from, to, raster, aggregation);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant from, Instant to, ComplexRaster raster) {
        return VariableInstanceDAO.getVarValues(viewType, viewIndex, instanceId, from, to, raster, null);
    }

    public static IVarValuesCollection getVarValues(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant from, Instant to, ComplexRaster raster, Aggregation aggregation) {
        GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, raster);
        request.addInstance(instanceId, aggregation);
        return VariableInstanceDAO.getVarValues(request)[0];
    }

    public static IVarValuesCollection getVarValuesWithTwoStepAggregation(RawValuesViewType viewType, Integer viewIndex, int instanceId, Instant from, Instant to, ComplexRaster raster, Aggregation aggregation, Raster raster2, Aggregation aggregation2) {
        GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, raster);
        request.addInstance(instanceId, aggregation);
        return VariableInstanceDAO.getVarValuesWithTwoStepAggregation(request, raster2, aggregation2)[0];
    }

    public static IVarValuesCollection[] getVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance[] instances, Instant from, Instant to) {
        GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, null);
        request.addInstances(instances);
        return VariableInstanceDAO.getVarValues(request);
    }

    public static IVarValuesCollection[] getVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance[] instances, Instant from, Instant to, ComplexRaster raster) {
        GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, raster);
        request.addInstances(instances);
        return VariableInstanceDAO.getVarValues(request);
    }

    public static IVarValuesCollection[] getVarValues(GetValuesRequest request) {
        String url = String.format("%s/varvalues/get", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)request));
        return (IVarValuesCollection[])response.readEntity(IVarValuesCollection[].class);
    }

    public static IVarValuesCollection[] getVarValuesWithTwoStepAggregation(GetValuesRequest request, Raster raster2, Aggregation aggr2) {
        String url = String.format("%s/varvalues/get/raster2=%s&aggr2=%s", PREFIX, raster2.name(), aggr2.name());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)request));
        return (IVarValuesCollection[])response.readEntity(IVarValuesCollection[].class);
    }

    public static DValArray[] getDVals(GetValuesRequest request) {
        String url = String.format("%s/dvals/get", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)request));
        return (DValArray[])response.readEntity(DValArray[].class);
    }

    public static DValArray[] getDValsWithTwoStepAggregation(GetValuesRequest request, Raster raster2, Aggregation aggr2) {
        String url = String.format("%s/dvals/get/raster2=%s&aggr2=%s", PREFIX, raster2.name(), aggr2.name());
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)request));
        return (DValArray[])response.readEntity(DValArray[].class);
    }

    public static IVarValuesCollection getVarValues(VariableInstance instance, ITimeRangeFilter timeRangeFilter, ComplexRaster complexRaster) {
        switch (timeRangeFilter.getType()) {
            case RealtimeView: {
                return VariableInstanceDAO.getVarValues(RawValuesViewType.RealtimeView, null, instance.getId(), complexRaster);
            }
            case GlobalView_Date: 
            case GlobalView_Timeline: {
                return VariableInstanceDAO.getVarValues(RawValuesViewType.GlobalView, null, instance, timeRangeFilter.getFrom(), timeRangeFilter.getTo(), complexRaster);
            }
            case CustomView: {
                return VariableInstanceDAO.getVarValues(RawValuesViewType.CustomView, timeRangeFilter.getCustomViewIndex(), instance, timeRangeFilter.getFrom(), timeRangeFilter.getTo(), complexRaster);
            }
        }
        return null;
    }

    public static IVarValue getGlobalViewVarValue(VariableInstance instance, Instant to) {
        return VariableInstanceDAO.getVarValue(RawValuesViewType.GlobalView, null, instance, to);
    }

    public static IVarValuesCollection getGlobalViewVarValues(VariableInstance instance, Instant from, Instant to) {
        return VariableInstanceDAO.getVarValues(RawValuesViewType.GlobalView, null, instance, from, to);
    }

    public static IVarValuesCollection getGlobalViewVarValues(VariableInstance instance, Instant from, Instant to, ComplexRaster virtualRaster) {
        return VariableInstanceDAO.getVarValues(RawValuesViewType.GlobalView, null, instance, from, to, virtualRaster);
    }

    public static SupplementValue getLastOriginalSupplementValue(VariableInstance instance, Integer selector) {
        return VariableInstanceDAO.getLastOriginalSupplementValue(instance.getId(), selector);
    }

    public static SupplementValue getLastOriginalSupplementValue(int instanceId, Integer selector) {
        String url = String.format("%s/lastsupplementvalue/get_original/id=%d&selector=%s", PREFIX, instanceId, selector != null ? selector.toString() : "");
        return (SupplementValue)Client.getWebTarget().path(url).request().get(SupplementValue.class);
    }

    public static SupplementValue[] getLastOriginalSupplementValues(VariableInstance[] instances, Integer selector) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/lastsupplementvalue/get_original/selector=%s", PREFIX, selector != null ? selector.toString() : "");
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (SupplementValue[])response.readEntity(SupplementValue[].class);
    }

    public static SupplementValue[] getOriginalSupplementValues(int instanceId) {
        String url = String.format("%s/supplementvalues/get_original/id=%d", PREFIX, instanceId);
        return (SupplementValue[])Client.getWebTarget().path(url).request().get(SupplementValue[].class);
    }

    public static SupplementValue[] getOriginalSupplementValues(int instanceId, Integer selector, Instant from, Instant to) {
        String url = String.format("%s/supplementvalues/get_original/id=%d&from=%d&to=%d&selector=%s", PREFIX, instanceId, from.toEpochMilli(), to.toEpochMilli(), selector != null ? selector.toString() : "");
        return (SupplementValue[])Client.getWebTarget().path(url).request().get(SupplementValue[].class);
    }

    public static SupplementValue[] getOriginalSupplementValues(VariableInstance[] instances, Integer selector, Instant ts) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/supplementvalue/get_original/ts=%d&selector=%s", PREFIX, ts.toEpochMilli(), selector != null ? selector.toString() : "");
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (SupplementValue[])response.readEntity(SupplementValue[].class);
    }

    public static void importSupplementValues(int instanceId, SupplementValue[] values) {
        String url = String.format("%s/supplementvalues/import/id=%d", PREFIX, instanceId);
        Client.getWebTarget().path(url).request().post(Entity.json((Object)values));
    }

    public static void deleteSupplementValues(int instanceId, Integer selector, Instant from, Instant to) {
        String url = String.format("%s/supplementvalues/delete/id=%d&from=%d&to=%d&selector=%s", PREFIX, instanceId, from.toEpochMilli(), to.toEpochMilli(), selector != null ? selector.toString() : "");
        Client.getWebTarget().path(url).request().get(OperationResult.class);
    }

    public static void applySupplementValuesChanges(SupplementValueChange[] changes, boolean overwriteLaterUnrasterizedValues) throws DAOOperationException {
        String url = String.format("%s/supplementvalues/apply_changes/overwrite_later_unrasterized_values=%s", PREFIX, Boolean.toString(overwriteLaterUnrasterizedValues));
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)changes));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void applyTimeIntervalValuesChanges(VariableInstanceTimeIntervalStringValues[] changes) throws DAOOperationException {
        String url = String.format("%s/time_interval_string_value/apply_changes", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)changes));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static IVarValue getCurrentValue(VariableInstance instance) {
        return VariableInstanceDAO.getCurrentValue(instance.getId());
    }

    public static IVarValue getCurrentValue(int instanceId) {
        String url = String.format("%s/currentvalue/get/id=%d", PREFIX, instanceId);
        return ((IVarValuesCollection)Client.getWebTarget().path(url).request().get(IVarValuesCollection.class)).getFirst();
    }

    public static IVarValue[] getCurrentValues(VariableInstance ... instances) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/currentvalues/get/", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return ((IVarValuesCollection)response.readEntity(IVarValuesCollection.class)).toArray();
    }

    public static IVarValue[] getCurrentValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance ... instances) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/currentvalues/get/view_type=%s&view_index=%s", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "");
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return ((IVarValuesCollection)response.readEntity(IVarValuesCollection.class)).toArray();
    }

    public static VarValue getCurrentVarValue(VariableInstance instance) {
        return VariableInstanceDAO.getCurrentVarValue(instance.getId());
    }

    public static VarValue getCurrentVarValue(int instanceId) {
        String url = String.format("%s/current_varvalue/get/id=%d", PREFIX, instanceId);
        return (VarValue)Client.getWebTarget().path(url).request().get(VarValue.class);
    }

    public static VarValue[] getLastValidVarValues(RawValuesViewType viewType, Integer viewIndex, VariableInstance[] instances, long maxAge) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/last_valid_varvalues/get/view_type=%s&view_index=%s&max_age=%d", PREFIX, viewType.name(), viewIndex != null ? viewIndex : "", maxAge);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (VarValue[])response.readEntity(VarValue[].class);
    }

    public static VarValue[] getCurrentVarValues(VariableInstance[] instances) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/current_varvalues/get/", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (VarValue[])response.readEntity(VarValue[].class);
    }

    public static TimeIntervalStringValueCollection[] getTimeIntervalStringValues(Instant from, Instant to, VariableInstance ... instances) {
        int[] ids = new int[instances.length];
        int i = 0;
        while (i < instances.length) {
            ids[i] = instances[i].getId();
            ++i;
        }
        String url = String.format("%s/time_interval_string_value/get/from=%d&to=%d", PREFIX, from != null ? Long.valueOf(from.toEpochMilli()) : "", to != null ? Long.valueOf(to.toEpochMilli()) : "");
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)ids));
        return (TimeIntervalStringValueCollection[])response.readEntity(TimeIntervalStringValueCollection[].class);
    }
}

