/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.variable.snapshot;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.snapshot.CreateVariableInstancesSnapshotRequest;
import de.elpro.ewms.core.variable.snapshot.GetVariableInstanceSnapshotGroupsRequest;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshotGroup;
import de.elpro.ewms.core.variable.value.DValArray;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import javax.ws.rs.client.Entity;

public class VariableInstanceSnapshotGroupDAO {
    public static final String PREFIX = "variable/instance/snapshot_group";

    public static int create(CreateVariableInstancesSnapshotRequest request) throws DAOOperationException {
        String path = String.format("%s/create", PREFIX);
        OperationResult result = (OperationResult)Client.getWebTarget().path(path).request().post(Entity.json((Object)request)).readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static VariableInstanceSnapshotGroup[] get(GetVariableInstanceSnapshotGroupsRequest request) throws DAOOperationException {
        String path = String.format("%s/get", PREFIX);
        return (VariableInstanceSnapshotGroup[])Client.getWebTarget().path(path).request().post(Entity.json((Object)request)).readEntity(VariableInstanceSnapshotGroup[].class);
    }

    public static VariableInstanceSnapshotGroup[] get(Transaction trx, GetVariableInstanceSnapshotGroupsRequest request) throws DAOOperationException {
        String path = String.format("%s/get/trx=%d", PREFIX, trx.getId());
        return (VariableInstanceSnapshotGroup[])Client.getWebTarget().path(path).request().post(Entity.json((Object)request)).readEntity(VariableInstanceSnapshotGroup[].class);
    }

    public static VariableInstance[] getVariableInstances(VariableInstanceSnapshotGroup group) throws DAOOperationException {
        String path = String.format("%s/get_variable_instances/id=%d", PREFIX, group.getId());
        return (VariableInstance[])Client.getWebTarget().path(path).request().get(VariableInstance[].class);
    }

    public static VariableInstance[] getVariableInstances(Transaction trx, VariableInstanceSnapshotGroup group) throws DAOOperationException {
        String path = String.format("%s/get_variable_instances/trx=%d&id=%d", PREFIX, trx.getId(), group.getId());
        return (VariableInstance[])Client.getWebTarget().path(path).request().get(VariableInstance[].class);
    }

    public static IVarValuesCollection getSnapshotVarValues(Transaction trx, VariableInstanceSnapshotGroup snapshotGroup, VariableInstance instance) {
        String path = String.format("%s/get/var_values/trx=%d&group_id=%d&instance_id=%d", PREFIX, trx.getId(), snapshotGroup.getId(), instance.getId());
        return (IVarValuesCollection)Client.getWebTarget().path(path).request().get(IVarValuesCollection.class);
    }

    public static DValArray getSnapshotDVals(Transaction trx, VariableInstanceSnapshotGroup snapshotGroup, VariableInstance instance) {
        String path = String.format("%s/get/dvals/trx=%d&group_id=%d&instance_id=%d", PREFIX, trx.getId(), snapshotGroup.getId(), instance.getId());
        return (DValArray)Client.getWebTarget().path(path).request().get(DValArray.class);
    }

    public static void delete(VariableInstanceSnapshotGroup[] groups) throws DAOOperationException {
        String path = String.format("%s/delete", PREFIX);
        int[] ids = new int[groups.length];
        int i = 0;
        while (i < groups.length) {
            ids[i] = groups[i].getId();
            ++i;
        }
        OperationResult result = (OperationResult)Client.getWebTarget().path(path).request().post(Entity.json((Object)ids)).readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void delete(Transaction trx, VariableInstanceSnapshotGroup[] groups) throws DAOOperationException {
        String path = String.format("%s/delete/trx=%d", PREFIX, trx.getId());
        int[] ids = new int[groups.length];
        int i = 0;
        while (i < groups.length) {
            ids[i] = groups[i].getId();
            ++i;
        }
        OperationResult result = (OperationResult)Client.getWebTarget().path(path).request().post(Entity.json((Object)ids)).readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

