/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.model.AnalysisErrorSeverity;
import de.elpro.ewms.core.lang.model.HoverInformation;
import de.elpro.ewms.core.lang.model.Location;
import de.elpro.ewms.core.lang.script.Characteristic3DReferenceNode;
import de.elpro.ewms.core.lang.script.FunctionNode;
import de.elpro.ewms.core.lang.script.FunctionParametersNode;
import de.elpro.ewms.core.lang.script.ScriptTree;
import de.elpro.ewms.core.lang.script.UnrecodnizedFunctionNode;
import de.elpro.ewms.core.lang.script.VariableDefinitionNode;
import de.elpro.ewms.core.lang.script.VariableNameNode;
import de.elpro.ewms.core.lang.script.VariableReferenceNode;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalAnalyzer {
    public static final char[] SPECIAL_CHARS = new char[]{'\u00b0', '^', '!', '\u00a7', '$', '%', '&', '(', ')', '=', '?', '`', '\u00b4', '{', '}', '[', ']', '*', '\\', '/', '+', '-', ',', '.', '#', '\'', '~', '@', '\"'};
    private static String documentationUrl = "https://eos-handbuch:eosReady@www.elpro.de/eos-dokumentation/";

    public static List<AnalysisError> checkVarNameToken(String token) {
        ArrayList<AnalysisError> errors = null;
        if (token == null || token.isEmpty()) {
            return Collections.singletonList(AnalysisError.syntacticError("Blank token"));
        }
        if (token.contains(" ") || token.contains("\r") || token.contains("\n")) {
            errors = new ArrayList<AnalysisError>();
            errors.add(AnalysisError.syntacticError("Token should contain no empty or new line characters."));
        }
        ArrayList<Character> forbiddenCharacters = null;
        int i = 0;
        while (i < SPECIAL_CHARS.length) {
            if (token.indexOf(SPECIAL_CHARS[i]) >= 0) {
                if (forbiddenCharacters == null) {
                    forbiddenCharacters = new ArrayList<Character>();
                }
                forbiddenCharacters.add(Character.valueOf(SPECIAL_CHARS[i]));
            }
            ++i;
        }
        if (forbiddenCharacters != null) {
            if (errors == null) {
                errors = new ArrayList();
            }
            StringBuilder sb = new StringBuilder();
            for (Character c : forbiddenCharacters) {
                if (!sb.isEmpty()) {
                    sb.append(" ");
                }
                sb.append(c);
            }
            errors.add(AnalysisError.syntacticError(String.format("Token should contain none of special characters: %s", sb)));
        }
        return errors;
    }

    public static List<AnalysisError> getErrors(ScriptTree tree, String ... varNames) {
        ArrayList<AnalysisError> errors = new ArrayList<AnalysisError>();
        HashSet<String> varNamesSet = new HashSet<String>();
        varNamesSet.addAll(Arrays.asList(varNames));
        LogicalAnalyzer.addErrors(tree, varNamesSet, errors);
        return errors;
    }

    private static void addErrors(ScriptTree tree, Set<String> varNames, ArrayList<AnalysisError> errors) {
        for (ScriptTree childTree : tree.getSubTrees()) {
            LogicalAnalyzer.addErrors(childTree, varNames, errors);
        }
        if (tree.getNode() instanceof UnrecodnizedFunctionNode) {
            UnrecodnizedFunctionNode ufn = (UnrecodnizedFunctionNode)tree.getNode();
            error = new AnalysisError();
            error.setLocation(ufn.getStartTokenLocation());
            error.setSeverity(AnalysisErrorSeverity.ERROR);
            error.setMessage(String.format("Unknown function name '%s'", ufn.getContent()));
            errors.add(error);
        } else if (tree.getNode() instanceof FunctionNode) {
            FunctionNode fn = (FunctionNode)tree.getNode();
            long argsCount = tree.getSubTrees().stream().filter(st -> !(st.getNode() instanceof FunctionParametersNode)).count();
            if (!((FormulaOperation)fn.getContent()).checkNumOfArguments((int)argsCount)) {
                FormulaOperation op = (FormulaOperation)fn.getContent();
                int startLoc = fn.getStartToken().getStopIndex() + 1;
                int endLoc = fn.getStopToken().getStopIndex();
                Location loc = new Location();
                loc.setOffset(startLoc);
                loc.setLength(endLoc - startLoc + 1);
                loc.setStartLine(fn.getStartToken().getLine());
                loc.setStartColumn(fn.getStartToken().getCharPositionInLine());
                AnalysisError error = new AnalysisError();
                error.setLocation(loc);
                error.setSeverity(AnalysisErrorSeverity.WARNING);
                StringBuilder errorMsg = new StringBuilder(String.format("Wrong number of arguments for operation '%s'. ", op.name()));
                if (op.getMaxArgs() != null) {
                    if (op.getMinArgs() != op.getMaxArgs().intValue()) {
                        errorMsg.append(String.format("Expectend number of args: %d - %d", op.getMinArgs(), op.getMaxArgs()));
                    } else {
                        errorMsg.append(String.format("Expectend number of args: %d", op.getMinArgs()));
                    }
                } else {
                    errorMsg.append(String.format("Expectend number of args: %d - inf.", op.getMinArgs()));
                }
                error.setMessage(errorMsg.toString());
                errors.add(error);
            }
        } else if (tree.getNode() instanceof VariableNameNode) {
            VariableNameNode vn = (VariableNameNode)tree.getNode();
            if (!varNames.contains(vn.getContent())) {
                error = new AnalysisError();
                error.setLocation(vn.getStartTokenLocation());
                error.setSeverity(AnalysisErrorSeverity.WARNING);
                error.setMessage(String.format("Potentially unknown variable placeholder '%s'", vn.getContent()));
                errors.add(error);
            }
        } else if (tree.getNode() instanceof VariableDefinitionNode) {
            VariableDefinitionNode vdn = (VariableDefinitionNode)tree.getNode();
            varNames.add((String)vdn.getContent());
        }
    }

    public static HoverInformation getHoverInformation(ScriptTree tree, int offset) {
        HoverInformation info;
        for (ScriptTree subTree : tree.getSubTrees()) {
            info = LogicalAnalyzer.getHoverInformation(subTree, offset);
            if (info == null) continue;
            return info;
        }
        if (tree.getNode() instanceof FunctionNode) {
            FunctionNode ufn = (FunctionNode)tree.getNode();
            Location location = ufn.getStartTokenLocation();
            if (location.getOffset() <= offset && offset < location.getOffset() + location.getLength()) {
                info = new HoverInformation();
                FormulaOperation op = (FormulaOperation)ufn.getContent();
                info.setOffset(location.getOffset());
                info.setLength(location.getLength());
                StringBuilder html = new StringBuilder(String.format("<p><b>%s</b></p>", op.name()));
                html.append(String.format("<p>%s</p>", op.getDescription()));
                if (op.getParams().length > 0) {
                    html.append("<p><b>Accepted parameters:</b>");
                    html.append("<ul>");
                    String[] stringArray = op.getParams();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String param = stringArray[n2];
                        html.append("<li>" + param + "</li>");
                        ++n2;
                    }
                    html.append("</ul></p>");
                }
                info.setDoc(html.toString());
                return info;
            }
        } else {
            String variableName;
            if (tree.getNode() instanceof Characteristic3DReferenceNode) {
                Characteristic3DReference c3dr = (Characteristic3DReference)((Characteristic3DReferenceNode)tree.getNode()).getContent();
                variableName = c3dr.getCharacteristicName();
                Transaction trx = Transactions.begin();
                Characteristic3D var = null;
                try {
                    var = Characteristic3DDAO.getByName((Transaction)trx, (String)variableName);
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                Location location = tree.getNode().getStartTokenLocation();
                int locationOffset = location.getOffset();
                int locationLength = location.getLength();
                int variableLength = variableName.length();
                int zwLength = c3dr.getZwSelection().length();
                int searchStrategyLength = c3dr.getSearchPolicy().name().length();
                if (location.getOffset() <= offset) {
                    HoverInformation info2 = new HoverInformation();
                    info2.setOffset(location.getOffset());
                    info2.setLength(location.getLength());
                    if (offset < locationOffset + locationLength + variableLength + zwLength) {
                        return LogicalAnalyzer.getCharacteristic3DHoverInfo(var, info2, variableName);
                    }
                    if (offset < locationOffset + locationLength + variableLength + zwLength + searchStrategyLength) {
                        return LogicalAnalyzer.getSearchPolicyHoverInfo(c3dr.getSearchPolicy(), info2);
                    }
                }
                return null;
            }
            if (tree.getNode() instanceof VariableReferenceNode) {
                VariableReference vr = (VariableReference)((VariableReferenceNode)tree.getNode()).getContent();
                variableName = ((VariableReference)((VariableReferenceNode)tree.getNode()).getContent()).getVariableName();
                Variable var = null;
                Transaction trx = Transactions.begin();
                try {
                    var = VariableDAO.getByName((Transaction)trx, (String)variableName);
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                Location location = tree.getNode().getStartTokenLocation();
                int locationOffset = location.getOffset();
                int locationLength = location.getLength();
                int variableLength = variableName.length();
                int searchStrategyLength = vr.getSearchPolicy().name().length();
                if (location.getOffset() <= offset) {
                    HoverInformation info3 = new HoverInformation();
                    info3.setOffset(location.getOffset());
                    info3.setLength(location.getLength());
                    if (offset < locationOffset + locationLength) {
                        return LogicalAnalyzer.getVariableHoverInfo(var, info3, variableName);
                    }
                    if (offset < locationOffset + locationLength + variableLength + searchStrategyLength) {
                        return LogicalAnalyzer.getSearchPolicyHoverInfo(vr.getSearchPolicy(), info3);
                    }
                }
            }
        }
        return null;
    }

    private static HoverInformation getSearchPolicyHoverInfo(SearchPolicy searchPolicy, HoverInformation info) {
        if (searchPolicy != null) {
            StringBuilder html = new StringBuilder("<p><b>Search Policy</b></p>");
            html.append(String.format("<p><b>%s (%s)</b></p>", searchPolicy.name(), searchPolicy.toString()));
            String a = "<a href=\"" + LogicalAnalyzer.getSearchPolicyUrl(searchPolicy) + "\" target=\"_blank\">Read more</a>";
            html.append(a);
            info.setDoc(html.toString());
        } else {
            StringBuilder html = new StringBuilder(String.format("<p>Unknown Search Policy</p>", new Object[0]));
            info.setDoc(html.toString());
        }
        return info;
    }

    private static String getSearchPolicyUrl(SearchPolicy searchPolicy) {
        String url = String.valueOf(documentationUrl) + "userHandbook/engineering/02formelEditor.html#";
        switch (searchPolicy) {
            case Auto: 
            case Parent: 
            case Children: 
            case ThisOrParent: 
            case ThisOrChildren: 
            case This: 
            case DirectChildren: 
            case TopChildren: 
            case All: {
                return String.valueOf(url) + searchPolicy.name().toLowerCase();
            }
        }
        return String.valueOf(url) + "objekt-angabe";
    }

    private static HoverInformation getVariableHoverInfo(Variable var, HoverInformation info, String variableName) {
        if (var != null) {
            StringBuilder html = new StringBuilder(String.format("<p><b>%s</b></p>", variableName));
            if (var.getDescription() != null && !var.getDescription().trim().isEmpty()) {
                html.append(String.format("<p>%s</p>", var.getDescription()));
            }
            html.append("<p><b>Variable:</b>");
            html.append("<ul>");
            html.append("<li>Physical Unit: " + var.getPhysicalUnit().getKey() + " [" + var.getPhysicalUnit().getName() + "]</li>");
            html.append("<li>Measuring Unit: " + var.getMeasuringUnit().getKey() + " [" + var.getMeasuringUnit().getDisplayUnitText() + "]</li>");
            html.append("</ul></p>");
            info.setDoc(html.toString());
        } else {
            StringBuilder html = new StringBuilder(String.format("<p>Unknown variable <b>%s</b> </p>", variableName));
            info.setDoc(html.toString());
        }
        return info;
    }

    private static HoverInformation getCharacteristic3DHoverInfo(Characteristic3D var, HoverInformation info, String variableName) {
        StringBuilder html;
        if (var != null) {
            html = new StringBuilder(String.format("<p><b>%s</b></p>", LogicalAnalyzer.escapeHTML(variableName)));
            if (var.getDescription() != null && !var.getDescription().trim().isEmpty()) {
                html.append(String.format("<p>%s</p>", var.getDescription()));
            }
            html.append("<b>input:</b>");
            html.append("<ul>");
            html.append("<li>X Axis Physical Unit: " + var.getInputXAxisPhysicalUnit().getKey() + " [" + var.getInputXAxisPhysicalUnit().getName() + "] - Measuring Unit: " + var.getInputXAxisMeasuringUnit().getKey() + " [\n" + var.getInputXAxisMeasuringUnit().getDisplayUnitText() + "]</li>");
            html.append("<li>Y Axis Physical Unit: " + var.getInputYAxisPhysicalUnit().getKey() + " [" + var.getInputYAxisPhysicalUnit().getName() + "] - Measuring Unit: " + var.getInputYAxisMeasuringUnit().getKey() + " [\n" + var.getInputYAxisMeasuringUnit().getDisplayUnitText() + "]</li>");
            html.append("</ul>");
            html.append("<b>output:</b>");
            html.append("<ul>");
            html.append("<li>Z Axis Physical Unit: " + var.getOutputZAxisPhysicalUnit().getKey() + " [" + var.getOutputZAxisPhysicalUnit().getName() + "] - Measuring Unit: " + var.getOutputZAxisMeasuringUnit().getKey() + " [\n" + var.getOutputZAxisMeasuringUnit().getDisplayUnitText() + "]</li>");
            if (var.getOutputWAxisPhysicalUnit() != null) {
                html.append("<li>W Axis Physical Unit: " + var.getOutputWAxisPhysicalUnit().getKey() + " [" + var.getOutputWAxisPhysicalUnit().getName() + "] - Measuring Unit: " + var.getOutputWAxisMeasuringUnit().getKey() + " [\n" + var.getOutputWAxisMeasuringUnit().getDisplayUnitText() + "]</li>");
            }
            html.append("</ul>");
        } else {
            html = new StringBuilder(String.format("<p>Unknown Characteristic3D reference <b>%s</b></p>", variableName));
        }
        info.setDoc(html.toString());
        return info;
    }

    public static String escapeHTML(String str) {
        return str.codePoints().mapToObj(c -> c > 127 || "\"'<>&".indexOf(c) != -1 ? "&#" + c + ";" : new String(Character.toChars(c))).collect(Collectors.joining());
    }
}

