/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang.script;

import de.elpro.ewms.core.lang.exceptions.UnknownVariableException;
import de.elpro.ewms.core.lang.script.CalculationExpressionRootNode;
import de.elpro.ewms.core.lang.script.CalculationScriptRootNode;
import de.elpro.ewms.core.lang.script.Characteristic3DExtremeLineInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DExtremeLineReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DReferenceNode;
import de.elpro.ewms.core.lang.script.ConstantNode;
import de.elpro.ewms.core.lang.script.ContentNode;
import de.elpro.ewms.core.lang.script.FunctionNode;
import de.elpro.ewms.core.lang.script.FunctionParameterNode;
import de.elpro.ewms.core.lang.script.FunctionParameterValue;
import de.elpro.ewms.core.lang.script.FunctionParametersNode;
import de.elpro.ewms.core.lang.script.Node;
import de.elpro.ewms.core.lang.script.TextNode;
import de.elpro.ewms.core.lang.script.UnrecodnizedFunctionNode;
import de.elpro.ewms.core.lang.script.VariableDefinitionNode;
import de.elpro.ewms.core.lang.script.VariableNameNode;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.FormulaInterpreter;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaNodeType;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScriptTree {
    private Node node;
    private ArrayList<ScriptTree> subTrees;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public List<ScriptTree> getSubTrees() {
        if (this.subTrees == null) {
            this.subTrees = new ArrayList();
        }
        return this.subTrees;
    }

    public boolean isLeaf() {
        return this.subTrees == null || this.subTrees.isEmpty();
    }

    public ScriptTree reduce() {
        if (this.isLeaf()) {
            return this;
        }
        if (this.node instanceof FunctionNode) {
            FunctionNode function = (FunctionNode)this.node;
            boolean tryReduce = false;
            FormulaOperation[] reduceOperations = new FormulaOperation[]{FormulaOperation.Sum, FormulaOperation.Mult};
            do {
                tryReduce = false;
                FormulaOperation[] formulaOperationArray = reduceOperations;
                int n = reduceOperations.length;
                int n2 = 0;
                while (n2 < n) {
                    FormulaOperation op = formulaOperationArray[n2];
                    if (function.getContent() == op) {
                        int i = 0;
                        while (i < this.getSubTrees().size()) {
                            FunctionNode subFunction;
                            ScriptTree addend = this.getSubTrees().get(i);
                            if (addend.node instanceof FunctionNode && (subFunction = (FunctionNode)addend.node).getContent() == op) {
                                this.getSubTrees().remove(i);
                                for (ScriptTree subSubTree : addend.getSubTrees()) {
                                    this.getSubTrees().add(i++, subSubTree);
                                }
                                tryReduce = true;
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            } while (tryReduce);
        }
        this.getSubTrees().forEach(t -> {
            ScriptTree scriptTree = t.reduce();
        });
        return this;
    }

    public List<UnknownVariableException> normalize() {
        return this.normalize(Collections.emptySet());
    }

    public List<UnknownVariableException> normalize(Set<String> knownVariableNames) {
        return this.normalize(knownVariableNames, new HashMap<String, ScriptTree>());
    }

    private List<UnknownVariableException> normalize(Set<String> knownVariableNames, Map<String, ScriptTree> varDefs) {
        if (this.isLeaf()) {
            if (this.node instanceof VariableNameNode) {
                VariableNameNode varDefNode = (VariableNameNode)this.node;
                String variableName = (String)varDefNode.getContent();
                if (varDefs.containsKey(variableName)) {
                    ScriptTree replacementTree = varDefs.get(variableName);
                    this.node = replacementTree.node;
                    this.subTrees = replacementTree.subTrees;
                } else if (!knownVariableNames.contains(variableName)) {
                    return Collections.singletonList(new UnknownVariableException(variableName, varDefNode.getStartToken().getLine(), varDefNode.getStartToken().getCharPositionInLine()));
                }
            }
            return null;
        }
        if (this.node instanceof CalculationExpressionRootNode) {
            return null;
        }
        if (this.node instanceof CalculationScriptRootNode) {
            List<UnknownVariableException> exceptions = null;
            int size = this.getSubTrees().size();
            int i = 0;
            while (i < size - 1) {
                ScriptTree varDefTree = this.getSubTrees().get(i);
                if (!varDefTree.isLeaf()) {
                    exceptions = this.concatUnknownVariablesExceptions(exceptions, varDefTree.normalize(knownVariableNames, varDefs));
                    VariableDefinitionNode varDefNode = (VariableDefinitionNode)varDefTree.node;
                    varDefs.put((String)varDefNode.getContent(), varDefTree.getSubTrees().get(0));
                }
                ++i;
            }
            ScriptTree resultTree = this.getSubTrees().get(size - 1);
            exceptions = this.concatUnknownVariablesExceptions(exceptions, resultTree.normalize(knownVariableNames, varDefs));
            this.node = new CalculationExpressionRootNode(null);
            this.subTrees = new ArrayList();
            this.subTrees.addAll(resultTree.getSubTrees());
            return exceptions;
        }
        List<UnknownVariableException> exceptions = null;
        for (ScriptTree subTree : this.getSubTrees()) {
            exceptions = this.concatUnknownVariablesExceptions(exceptions, subTree.normalize(knownVariableNames, varDefs));
        }
        return exceptions;
    }

    private List<UnknownVariableException> concatUnknownVariablesExceptions(List<UnknownVariableException> exceptions, List<UnknownVariableException> subTreeExceptions) {
        if (subTreeExceptions != null) {
            if (exceptions == null) {
                exceptions = new ArrayList<UnknownVariableException>();
            }
            exceptions.addAll(subTreeExceptions);
        }
        return exceptions;
    }

    public FormulaNode toFormula() {
        if (this.node instanceof CalculationExpressionRootNode) {
            return this.getSubTrees().get(0).toFormula();
        }
        if (this.node instanceof ConstantNode) {
            String constantValue = FormulaInterpreter.getConstantValue((String)((String)((ConstantNode)this.node).getContent()));
            return new FormulaNode(constantValue);
        }
        if (this.node instanceof TextNode) {
            String text = (String)((TextNode)this.node).getContent();
            return new FormulaNode(FormulaNodeType.Text, text);
        }
        if (this.node instanceof ContentNode) {
            FormulaNode formula;
            if (this.node instanceof Characteristic3DReferenceNode) {
                Characteristic3DReference c3dr = (Characteristic3DReference)((Characteristic3DReferenceNode)this.node).getContent();
                formula = new FormulaNode(FormulaNodeType.Characteristic3DRef, String.format("$%s->%s", c3dr.getCharacteristicName(), c3dr.getSearchPolicy().name()));
                formula.getOperationParameters().put("OutputAxis", c3dr.getZwSelection());
            } else if (this.node instanceof Characteristic3DInstanceReferenceNode) {
                Characteristic3DInstanceReference c3dir = (Characteristic3DInstanceReference)((Characteristic3DInstanceReferenceNode)this.node).getContent();
                formula = new FormulaNode(FormulaNodeType.Characteristic3DRef, String.format("$%s->%s", c3dir.getCharacteristicName(), c3dir.getStructureObjectKey()));
                formula.getOperationParameters().put("OutputAxis", c3dir.getZwSelection());
            } else if (this.node instanceof Characteristic3DExtremeLineReferenceNode) {
                c3elr = (Characteristic3DExtremeLineReference)((Characteristic3DExtremeLineReferenceNode)this.node).getContent();
                formula = new FormulaNode(FormulaNodeType.Characteristic3DExtremeLineRef, String.format("$%s->%s", c3elr.getCharacteristicName(), c3elr.getSearchPolicy().name()));
                formula.getOperationParameters().put("OutputAxis", c3elr.isGetX() ? "x" : "y");
                if (c3elr.isSearchForMinumum()) {
                    formula.getOperationParameters().put("Minimize", null);
                } else {
                    formula.getOperationParameters().put("Maximize", null);
                }
                formula.getOperationParameters().put("ReferenceAxis", c3elr.isOverZ() ? "z" : "w");
            } else if (this.node instanceof Characteristic3DExtremeLineInstanceReferenceNode) {
                c3elr = (Characteristic3DExtremeLineInstanceReference)((Characteristic3DExtremeLineInstanceReferenceNode)this.node).getContent();
                formula = new FormulaNode(FormulaNodeType.Characteristic3DExtremeLineRef, String.format("$%s->%s", c3elr.getCharacteristicName(), c3elr.getStructureObjectKey()));
                formula.getOperationParameters().put("OutputAxis", c3elr.isGetX() ? "x" : "y");
                if (c3elr.isSearchForMinumum()) {
                    formula.getOperationParameters().put("Minimize", null);
                } else {
                    formula.getOperationParameters().put("Maximize", null);
                }
                formula.getOperationParameters().put("ReferenceAxis", c3elr.isOverZ() ? "z" : "w");
            } else {
                formula = new FormulaNode(((ContentNode)this.node).getContent().toString());
            }
            if (this.node instanceof FunctionNode || this.node instanceof UnrecodnizedFunctionNode) {
                for (ScriptTree subTree : this.getSubTrees()) {
                    if (!(subTree.getNode() instanceof FunctionParametersNode)) {
                        formula.getParameters().add(subTree.toFormula());
                        continue;
                    }
                    for (ScriptTree paramTree : subTree.getSubTrees()) {
                        FunctionParameterNode paramNode = (FunctionParameterNode)paramTree.node;
                        if (paramTree.isLeaf()) {
                            formula.getOperationParameters().put((String)paramNode.getContent(), null);
                            continue;
                        }
                        FunctionParameterValue paramValue = (FunctionParameterValue)paramTree.getSubTrees().get((int)0).node;
                        formula.getOperationParameters().put((String)paramNode.getContent(), (String)paramValue.getContent());
                    }
                }
                return formula;
            }
            for (ScriptTree subTree : this.getSubTrees()) {
                formula.getParameters().add(subTree.toFormula());
            }
            return formula;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.node.toString());
        sb.append("\r\n");
        if (this.subTrees == null) {
            return sb.toString();
        }
        for (ScriptTree subTree : this.subTrees) {
            sb.append(" |-");
            String subTreeText = subTree.toString();
            String[] parts = subTreeText.split("\r\n");
            int i = 0;
            while (i < parts.length) {
                if (i == 0) {
                    sb.append(" ");
                } else {
                    sb.append("   ");
                }
                sb.append(parts[i]);
                sb.append("\r\n");
                ++i;
            }
        }
        return sb.toString();
    }
}

